/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.imap.processor.fetch.PartialFetchBodyElement;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class PartialFetchBodyElementTest {
    private static final long NUMBER_OF_OCTETS = 100L;
    FetchResponse.BodyElement mockBodyElement;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mockBodyElement = (FetchResponse.BodyElement)this.mockery.mock(FetchResponse.BodyElement.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).getName();
                this.will(1.returnValue((Object)"Name"));
            }
        });
    }

    @Test
    public void testSizeShouldBeNumberOfOctetsWhenSizeMoreWhenStartIsZero() throws Exception {
        long moreThanNumberOfOctets = 101L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 0L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(2.returnValue((Object)new Long(101L)));
            }
        });
        Assert.assertEquals((String)"Size is more than number of octets so should be number of octets", (long)100L, (long)element.size());
    }

    @Test
    public void testSizeShouldBeSizeWhenNumberOfOctetsMoreWhenStartIsZero() throws Exception {
        long lessThanNumberOfOctets = 99L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 0L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(3.returnValue((Object)new Long(99L)));
            }
        });
        Assert.assertEquals((String)"Size is less than number of octets so should be size", (long)99L, (long)element.size());
    }

    @Test
    public void testWhenStartPlusNumberOfOctetsIsMoreThanSizeSizeShouldBeSizeMinusStart() throws Exception {
        long size = 60L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 10L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(4.returnValue((Object)new Long(60L)));
            }
        });
        Assert.assertEquals((String)"Size is less than number of octets so should be size", (long)50L, (long)element.size());
    }

    @Test
    public void testWhenStartPlusNumberOfOctetsIsLessThanSizeSizeShouldBeNumberOfOctetsMinusStart() throws Exception {
        long size = 100L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 10L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(5.returnValue((Object)new Long(100L)));
            }
        });
        Assert.assertEquals((String)"Size is less than number of octets so should be size", (long)90L, (long)element.size());
    }

    @Test
    public void testSizeShouldBeZeroWhenStartIsMoreThanSize() throws Exception {
        long size = 100L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 1000L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(6.returnValue((Object)new Long(100L)));
            }
        });
        Assert.assertEquals((String)"Size is less than number of octets so should be size", (long)0L, (long)element.size());
    }

    @Test
    public void testSizeShouldBeNumberOfOctetsWhenStartMoreThanOctets() throws Exception {
        long size = 2000L;
        PartialFetchBodyElement element = new PartialFetchBodyElement(this.mockBodyElement, 1000L, 100L);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.BodyElement)this.oneOf(PartialFetchBodyElementTest.this.mockBodyElement)).size();
                this.will(7.returnValue((Object)new Long(2000L)));
            }
        });
        Assert.assertEquals((String)"Content size is less than start. Size should be zero.", (long)100L, (long)element.size());
    }
}

