/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.processor.fetch.MessageResultUtils;
import org.apache.james.mailbox.model.MessageResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageResultUtilsTest {
    private static final String[] NAMES = new String[]{"One", "Three"};
    Header headerOne;
    Header headerTwo;
    Header headerThree;
    List<MessageResult.Header> headers;

    @Before
    public void setUp() throws Exception {
        this.headerOne = new Header("One");
        this.headerTwo = new Header("Two");
        this.headerThree = new Header("Three");
        this.headers = new ArrayList<MessageResult.Header>();
        this.headers.add(this.headerOne);
        this.headers.add(this.headerTwo);
        this.headers.add(this.headerThree);
    }

    @Test
    public void testGetAllContent() throws Exception {
        List results = MessageResultUtils.getAll(this.headers.iterator());
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((Object)this.headerOne, results.get(0));
        Assert.assertEquals((Object)this.headerTwo, results.get(1));
        Assert.assertEquals((Object)this.headerThree, results.get(2));
    }

    @Test
    public void testGetMatching() throws Exception {
        List results = MessageResultUtils.getMatching((String[])NAMES, this.headers.iterator());
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)this.headerOne, results.get(0));
        Assert.assertEquals((Object)this.headerThree, results.get(1));
    }

    @Test
    public void testGetNotMatching() throws Exception {
        List results = MessageResultUtils.getNotMatching((String[])NAMES, this.headers.iterator());
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)this.headerTwo, results.get(0));
    }

    @Test
    public void testGetMatchingSingle() throws Exception {
        Assert.assertEquals((Object)this.headerOne, (Object)MessageResultUtils.getMatching((String)"One", this.headers.iterator()));
        Assert.assertEquals((Object)this.headerThree, (Object)MessageResultUtils.getMatching((String)"Three", this.headers.iterator()));
        Assert.assertNull((Object)MessageResultUtils.getMatching((String)"Missing", this.headers.iterator()));
    }

    private static class Header
    implements MessageResult.Header {
        public String name;
        public String value;

        public Header(String name) {
            this.name = name;
            this.value = "Value";
        }

        public long size() {
            return 0L;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }
    }
}

