/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.FakeMailboxListenerAdded;
import org.apache.james.imap.processor.base.FakeMailboxListenerFlagsUpdate;
import org.apache.james.imap.processor.base.SelectedMailboxImpl;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class MailboxEventAnalyserTest {
    private static final long BASE_SESSION_ID = 99L;
    private MailboxPath mailboxPath = new MailboxPath("namespace", "user", "name");
    private final MailboxManager mockManager = new MailboxManager(){

        public void removeListener(MailboxPath mailboxPath, MailboxListener listner, MailboxSession session) throws MailboxException {
        }

        public void removeGlobalListener(MailboxListener listner, MailboxSession session) throws MailboxException {
        }

        public void addListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        }

        public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        }

        public void startProcessingRequest(MailboxSession session) {
        }

        public void endProcessingRequest(MailboxSession session) {
        }

        public List<MailboxMetaData> search(MailboxQuery expression, MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void renameMailbox(MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean mailboxExists(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void logout(MailboxSession session, boolean force) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public MailboxSession login(String userid, String passwd, Logger log) throws BadCredentialsException, MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public List<MailboxPath> list(MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public MessageManager getMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
            return new MessageManager(){

                public long getMessageCount(MailboxSession mailboxSession) throws MailboxException {
                    return 1L;
                }

                public boolean isWriteable(MailboxSession session) {
                    return false;
                }

                public boolean isModSeqPermanent(MailboxSession session) {
                    return false;
                }

                public Iterator<Long> search(SearchQuery searchQuery, MailboxSession mailboxSession) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public Iterator<Long> expunge(MessageRange set, MailboxSession mailboxSession) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public Map<Long, Flags> setFlags(Flags flags, boolean value, boolean replace, MessageRange set, MailboxSession mailboxSession) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public long appendMessage(InputStream msgIn, Date internalDate, MailboxSession mailboxSession, boolean isRecent, Flags flags) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public MessageResultIterator getMessages(MessageRange set, MessageResult.FetchGroup fetchGroup, MailboxSession mailboxSession) throws MailboxException {
                    return new MessageResultIterator(){
                        boolean done = false;

                        public void remove() {
                            throw new UnsupportedOperationException("Not implemented");
                        }

                        public MessageResult next() {
                            this.done = true;
                            return new MessageResult(){

                                public int compareTo(MessageResult o) {
                                    return 0;
                                }

                                public long getUid() {
                                    return 1L;
                                }

                                public long getModSeq() {
                                    return 0L;
                                }

                                public Flags getFlags() {
                                    return new Flags();
                                }

                                public long getSize() {
                                    return 0L;
                                }

                                public Date getInternalDate() {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public MimeDescriptor getMimeDescriptor() throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Iterator<MessageResult.Header> iterateHeaders(MessageResult.MimePath path) throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Iterator<MessageResult.Header> iterateMimeHeaders(MessageResult.MimePath path) throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Content getFullContent() throws MailboxException, IOException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Content getFullContent(MessageResult.MimePath path) throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Content getBody() throws MailboxException, IOException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Content getBody(MessageResult.MimePath path) throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Content getMimeBody(MessageResult.MimePath path) throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }

                                public Headers getHeaders() throws MailboxException {
                                    throw new UnsupportedOperationException("Not implemented");
                                }
                            };
                        }

                        public boolean hasNext() {
                            return !this.done;
                        }

                        public MailboxException getException() {
                            return null;
                        }
                    };
                }

                public MessageManager.MetaData getMetaData(boolean resetRecent, MailboxSession mailboxSession, MessageManager.MetaData.FetchGroup fetchGroup) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public boolean hasRight(MailboxACL.MailboxACLRight right, MailboxSession session) throws MailboxException {
                    return true;
                }

                public MailboxACL.MailboxACLRights myRights(MailboxSession session) throws MailboxException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public MailboxACL.MailboxACLRights[] listRigths(MailboxACL.MailboxACLEntryKey identifier, MailboxSession session) throws UnsupportedRightException {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public void setRights(MailboxACL.MailboxACLEntryKey mailboxACLEntryKey, MailboxACL.EditMode editMode, MailboxACL.MailboxACLRights mailboxAclRights) throws UnsupportedRightException {
                    throw new UnsupportedOperationException("Not implemented");
                }
            };
        }

        public char getDelimiter() {
            return '.';
        }

        public void deleteMailbox(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public MailboxSession createSystemSession(String userName, Logger log) throws BadCredentialsException, MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void createMailbox(MailboxPath mailboxPath, MailboxSession mailboxSession) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public List<MessageRange> copyMessages(MessageRange set, MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
            throw new UnsupportedOperationException("Not implemented");
        }
    };

    @Test
    public void testShouldBeNoSizeChangeOnOtherEvent() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(0L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        MailboxListener.Event event = new MailboxListener.Event(mSession, this.mailboxPath){};
        analyser.event(event);
        Assert.assertFalse((boolean)analyser.isSizeChanged());
    }

    @Test
    public void testShouldBeNoSizeChangeOnAdded() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(0L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        analyser.event((MailboxListener.Event)new FakeMailboxListenerAdded(mSession, Arrays.asList(11L), this.mailboxPath));
        Assert.assertTrue((boolean)analyser.isSizeChanged());
    }

    @Test
    public void testShouldNoSizeChangeAfterReset() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(99L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        analyser.event((MailboxListener.Event)new FakeMailboxListenerAdded(mSession, Arrays.asList(11L), this.mailboxPath));
        analyser.resetEvents();
        Assert.assertFalse((boolean)analyser.isSizeChanged());
    }

    @Test
    public void testShouldNotSetUidWhenNoSystemFlagChange() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(11L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(mSession, Arrays.asList(90L), Arrays.asList(new UpdatedFlags(90L, -1L, new Flags(), new Flags())), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        Assert.assertNotNull((Object)analyser.flagUpdateUids());
        Assert.assertFalse((boolean)analyser.flagUpdateUids().iterator().hasNext());
    }

    @Test
    public void testShouldSetUidWhenSystemFlagChange() throws Exception {
        long uid = 900L;
        MyMailboxSession mSession = new MyMailboxSession(11L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(new MyMailboxSession(41L), Arrays.asList(900L), Arrays.asList(new UpdatedFlags(900L, -1L, new Flags(), new Flags(Flags.Flag.ANSWERED))), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        Iterator iterator = analyser.flagUpdateUids().iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)new Long(900L), iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testShouldClearFlagUidsUponReset() throws Exception {
        long uid = 900L;
        MyMailboxSession mSession = new MyMailboxSession(11L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(mSession, Arrays.asList(900L), Arrays.asList(new UpdatedFlags(900L, -1L, new Flags(), new Flags(Flags.Flag.ANSWERED))), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        analyser.event((MailboxListener.Event)update);
        analyser.deselect();
        Assert.assertNotNull((Object)analyser.flagUpdateUids());
        Assert.assertFalse((boolean)analyser.flagUpdateUids().iterator().hasNext());
    }

    @Test
    public void testShouldSetUidWhenSystemFlagChangeDifferentSessionInSilentMode() throws Exception {
        long uid = 900L;
        MyMailboxSession mSession = new MyMailboxSession(11L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(new MyMailboxSession(99L), Arrays.asList(900L), Arrays.asList(new UpdatedFlags(900L, -1L, new Flags(), new Flags(Flags.Flag.ANSWERED))), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        analyser.setSilentFlagChanges(true);
        analyser.event((MailboxListener.Event)update);
        Iterator iterator = analyser.flagUpdateUids().iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)new Long(900L), iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testShouldNotSetUidWhenSystemFlagChangeSameSessionInSilentMode() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(99L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(mSession, Arrays.asList(345L), Arrays.asList(new UpdatedFlags(345L, -1L, new Flags(), new Flags())), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        analyser.setSilentFlagChanges(true);
        analyser.event((MailboxListener.Event)update);
        Iterator iterator = analyser.flagUpdateUids().iterator();
        Assert.assertNotNull(iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testShouldNotSetUidWhenOnlyRecentFlagUpdated() throws Exception {
        MyMailboxSession mSession = new MyMailboxSession(99L);
        MyImapSession imapsession = new MyImapSession(mSession);
        SelectedMailboxImpl analyser = new SelectedMailboxImpl(this.mockManager, (ImapSession)imapsession, this.mailboxPath);
        FakeMailboxListenerFlagsUpdate update = new FakeMailboxListenerFlagsUpdate(mSession, Arrays.asList(886L), Arrays.asList(new UpdatedFlags(886L, -1L, new Flags(), new Flags(Flags.Flag.RECENT))), this.mailboxPath);
        analyser.event((MailboxListener.Event)update);
        Iterator iterator = analyser.flagUpdateUids().iterator();
        Assert.assertNotNull(iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public MailboxACL.MailboxACLRights myRights(MailboxSession session) throws MailboxException {
        return null;
    }

    private class MyImapSession
    implements ImapSession {
        private MailboxSession mSession;

        public MyImapSession(MailboxSession mSession) {
            this.mSession = mSession;
        }

        public boolean supportStartTLS() {
            return false;
        }

        public boolean startTLS() {
            return false;
        }

        public boolean startCompression() {
            return false;
        }

        public void setAttribute(String key, Object value) {
        }

        public void selected(SelectedMailbox mailbox) {
        }

        public void pushLineHandler(ImapLineHandler lineHandler) {
        }

        public void popLineHandler() {
        }

        public void logout() {
        }

        public boolean isCompressionSupported() {
            return false;
        }

        public ImapSessionState getState() {
            return ImapSessionState.AUTHENTICATED;
        }

        public SelectedMailbox getSelected() {
            return null;
        }

        public Logger getLog() {
            return null;
        }

        public Object getAttribute(String key) {
            if (key.equals("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY")) {
                return this.mSession;
            }
            return null;
        }

        public void deselect() {
        }

        public void authenticated() {
        }

        public boolean isPlainAuthDisallowed() {
            return false;
        }

        public boolean isTLSActive() {
            return false;
        }

        public boolean supportMultipleNamespaces() {
            return false;
        }

        public boolean isCompressionActive() {
            return false;
        }
    }

    private final class MyMailboxSession
    implements MailboxSession {
        private long sessionId;

        public MyMailboxSession(long sessionId) {
            this.sessionId = sessionId;
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public void close() {
        }

        public Map<Object, Object> getAttributes() {
            return null;
        }

        public Logger getLog() {
            return null;
        }

        public String getOtherUsersSpace() {
            return null;
        }

        public char getPathDelimiter() {
            return '\u0000';
        }

        public String getPersonalSpace() {
            return null;
        }

        public Collection<String> getSharedSpaces() {
            return null;
        }

        public MailboxSession.User getUser() {
            return null;
        }

        public boolean isOpen() {
            return false;
        }

        public MailboxSession.SessionType getType() {
            return MailboxSession.SessionType.System;
        }
    }
}

