/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.SetACLRequest;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;
import org.apache.james.imap.processor.SetACLProcessor;
import org.apache.james.imap.processor.StatusResponseTypeMatcher;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SetACLProcessorTest {
    private static final String MAILBOX_NAME = "INBOX";
    private static final String USER_1 = "user1";
    private static final String SET_RIGHTS = "aw";
    private static final String UNSUPPORTED_RIGHT = "W";
    ImapSession imapSessionStub;
    MailboxManager mailboxManagerStub;
    MailboxSession mailboxSessionStub;
    MessageManager messageManagerStub;
    MessageManager.MetaData metaDataStub;
    Mockery mockery = new JUnit4Mockery();
    SetACLRequest replaceACLRequest;
    UnpooledStatusResponseFactory statusResponseFactory;
    SetACLProcessor subject;
    MailboxSession.User user1Stub;
    MailboxACL.MailboxACLEntryKey user1Key;
    MailboxACL.MailboxACLRights setRights;

    private Expectations prepareRightsExpectations() throws MailboxException {
        return new Expectations(){
            {
                ((ImapSession)this.allowing(SetACLProcessorTest.this.imapSessionStub)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(1.returnValue((Object)SetACLProcessorTest.this.mailboxSessionStub));
                ((ImapSession)this.allowing(SetACLProcessorTest.this.imapSessionStub)).getState();
                this.will(1.returnValue((Object)ImapSessionState.AUTHENTICATED));
                ((MailboxSession)this.allowing(SetACLProcessorTest.this.mailboxSessionStub)).getUser();
                this.will(1.returnValue((Object)SetACLProcessorTest.this.user1Stub));
                ((MailboxSession.User)this.allowing(SetACLProcessorTest.this.user1Stub)).getUserName();
                this.will(1.returnValue((Object)SetACLProcessorTest.USER_1));
                ((MailboxManager)this.allowing(SetACLProcessorTest.this.mailboxManagerStub)).startProcessingRequest((MailboxSession)this.with(1.same((Object)SetACLProcessorTest.this.mailboxSessionStub)));
                ((MailboxManager)this.allowing(SetACLProcessorTest.this.mailboxManagerStub)).endProcessingRequest((MailboxSession)this.with(1.same((Object)SetACLProcessorTest.this.mailboxSessionStub)));
                ((MessageManager)this.allowing(SetACLProcessorTest.this.messageManagerStub)).getMetaData(this.with(1.any(Boolean.class)), (MailboxSession)this.with(1.same((Object)SetACLProcessorTest.this.mailboxSessionStub)), (MessageManager.MetaData.FetchGroup)this.with(1.any(MessageManager.MetaData.FetchGroup.class)));
                this.will(1.returnValue((Object)SetACLProcessorTest.this.metaDataStub));
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.statusResponseFactory = new UnpooledStatusResponseFactory();
        this.mailboxManagerStub = (MailboxManager)this.mockery.mock(MailboxManager.class);
        this.subject = new SetACLProcessor((ImapProcessor)this.mockery.mock(ImapProcessor.class), this.mailboxManagerStub, (StatusResponseFactory)this.statusResponseFactory);
        this.imapSessionStub = (ImapSession)this.mockery.mock(ImapSession.class);
        this.mailboxSessionStub = (MailboxSession)this.mockery.mock(MailboxSession.class);
        this.user1Stub = (MailboxSession.User)this.mockery.mock(MailboxSession.User.class);
        this.messageManagerStub = (MessageManager)this.mockery.mock(MessageManager.class);
        this.metaDataStub = (MessageManager.MetaData)this.mockery.mock(MessageManager.MetaData.class);
        this.replaceACLRequest = new SetACLRequest("TAG", ImapCommand.anyStateCommand((String)"Name"), MAILBOX_NAME, USER_1, SET_RIGHTS);
        this.user1Key = new SimpleMailboxACL.SimpleMailboxACLEntryKey(USER_1);
        this.setRights = new SimpleMailboxACL.Rfc4314Rights(SET_RIGHTS);
    }

    @Test
    public void testUnsupportedRight() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)false));
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.BAD)));
            }
        });
        this.subject.doProcess((ImapRequest)new SetACLRequest("TAG", ImapCommand.anyStateCommand((String)"Name"), MAILBOX_NAME, USER_1, UNSUPPORTED_RIGHT), responderMock, this.imapSessionStub);
    }

    @Test
    public void testNoListRight() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)false));
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.replaceACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testNoAdminRight() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)false));
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.replaceACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testInexistentMailboxName() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.throwException((Throwable)new MailboxNotFoundException(MAILBOX_NAME)));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.replaceACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testAddRights() throws Exception {
        this.testOp("+", MailboxACL.EditMode.ADD);
    }

    private void testOp(String prefix, MailboxACL.EditMode editMode) throws MailboxException {
        MailboxACL acl = SimpleMailboxACL.OWNER_FULL_ACL;
        Expectations expectations = this.prepareRightsExpectations();
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).setRights((MailboxACL.MailboxACLEntryKey)expectations.with(Expectations.equal((Object)this.user1Key)), (MailboxACL.EditMode)expectations.with(Expectations.equal((Object)editMode)), (MailboxACL.MailboxACLRights)expectations.with(Expectations.equal((Object)this.setRights)));
        ((MessageManager.MetaData)expectations.allowing((Object)this.metaDataStub)).getACL();
        expectations.will(Expectations.returnValue((Object)acl));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.OK)));
            }
        });
        SetACLRequest r = new SetACLRequest("TAG", ImapCommand.anyStateCommand((String)"Name"), MAILBOX_NAME, USER_1, prefix + SET_RIGHTS);
        this.subject.doProcess((ImapRequest)r, responderMock, this.imapSessionStub);
    }

    @Test
    public void testRemoveRights() throws Exception {
        this.testOp("-", MailboxACL.EditMode.REMOVE);
    }

    @Test
    public void testReplaceRights() throws Exception {
        this.testOp("", MailboxACL.EditMode.REPLACE);
    }
}

