/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.request.SearchOperation;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.SearchRequest;
import org.apache.james.imap.message.response.SearchResponse;
import org.apache.james.imap.processor.SearchProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SearchQuery;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JMock.class)
public class SearchProcessorTest {
    private static final int DAY = 6;
    private static final int MONTH = 6;
    private static final int YEAR = 1944;
    private static final DayMonthYear DAY_MONTH_YEAR = new DayMonthYear(6, 6, 1944);
    private static final long SIZE = 1729L;
    private static final String KEYWORD = "BD3";
    private static final long[] EMPTY = new long[0];
    private static final String TAG = "TAG";
    private static final String ADDRESS = "John Smith <john@example.org>";
    private static final String SUBJECT = "Myriad Harbour";
    private static final IdRange[] IDS = new IdRange[]{new IdRange(1L), new IdRange(42L, 1048L)};
    private static final SearchQuery.NumericRange[] RANGES = new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(1L), new SearchQuery.NumericRange(42L, 1048L)};
    private static final MailboxPath mailboxPath = new MailboxPath("namespace", "user", "name");
    SearchProcessor processor;
    ImapProcessor next;
    ImapProcessor.Responder responder;
    ImapSession session;
    ImapCommand command;
    StatusResponseFactory serverResponseFactory;
    StatusResponse statusResponse;
    MessageManager mailbox;
    MailboxManager mailboxManager;
    MailboxSession mailboxSession;
    SelectedMailbox selectedMailbox;
    private Mockery mockery = new JUnit4Mockery();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Before
    public void setUp() throws Exception {
        this.serverResponseFactory = (StatusResponseFactory)this.mockery.mock(StatusResponseFactory.class);
        this.session = (ImapSession)this.mockery.mock(ImapSession.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.next = (ImapProcessor)this.mockery.mock(ImapProcessor.class);
        this.responder = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.statusResponse = (StatusResponse)this.mockery.mock(StatusResponse.class);
        this.mailbox = (MessageManager)this.mockery.mock(MessageManager.class);
        this.mailboxManager = (MailboxManager)this.mockery.mock(MailboxManager.class);
        this.mailboxSession = (MailboxSession)this.mockery.mock(MailboxSession.class);
        this.selectedMailbox = (SelectedMailbox)this.mockery.mock(SelectedMailbox.class);
        this.processor = new SearchProcessor(this.next, this.mailboxManager, this.serverResponseFactory);
        this.expectOk();
    }

    private void allowUnsolicitedResponses() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.atMost(1).of((Object)SearchProcessorTest.this.session)).getAttribute((String)this.with(1.equal((Object)"org.apache.james.api.imap.MAILBOX_USER_ATTRIBUTE_SESSION_KEY")));
                this.will(1.returnValue((Object)"user"));
                ((ImapSession)this.atMost(1).of((Object)SearchProcessorTest.this.session)).getAttribute((String)this.with(1.equal((Object)"org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY")));
                this.will(1.returnValue((Object)SearchProcessorTest.this.mailboxSession));
            }
        });
    }

    @Test
    public void testSequenceSetUpperUnlimited() throws Exception {
        this.expectsGetSelectedMailbox();
        IdRange[] ids = new IdRange[]{new IdRange(1L, Long.MAX_VALUE)};
        SearchQuery.NumericRange[] ranges = new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(42L, 100L)};
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).existsCount();
                this.will(2.returnValue((Object)100L));
                ((SelectedMailbox)this.oneOf(SearchProcessorTest.this.selectedMailbox)).uid(this.with(2.equal((Object)1)));
                this.will(2.returnValue((Object)42L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getFirstUid();
                this.will(2.returnValue((Object)1L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getLastUid();
                this.will(2.returnValue((Object)100L));
            }
        });
        this.allowUnsolicitedResponses();
        this.check(SearchKey.buildSequenceSet((IdRange[])ids), SearchQuery.uid((SearchQuery.NumericRange[])ranges));
    }

    @Test
    public void testSequenceSetMsnRange() throws Exception {
        this.expectsGetSelectedMailbox();
        IdRange[] ids = new IdRange[]{new IdRange(1L, 5L)};
        SearchQuery.NumericRange[] ranges = new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(42L, 1729L)};
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).existsCount();
                this.will(3.returnValue((Object)2L));
                ((SelectedMailbox)this.oneOf(SearchProcessorTest.this.selectedMailbox)).uid(this.with(3.equal((Object)1)));
                this.will(3.returnValue((Object)42L));
                ((SelectedMailbox)this.oneOf(SearchProcessorTest.this.selectedMailbox)).uid(this.with(3.equal((Object)5)));
                this.will(3.returnValue((Object)1729L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getFirstUid();
                this.will(3.returnValue((Object)1L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getLastUid();
                this.will(3.returnValue((Object)Long.MAX_VALUE));
            }
        });
        this.allowUnsolicitedResponses();
        this.check(SearchKey.buildSequenceSet((IdRange[])ids), SearchQuery.uid((SearchQuery.NumericRange[])ranges));
    }

    @Test
    public void testSequenceSetSingleMsn() throws Exception {
        this.expectsGetSelectedMailbox();
        IdRange[] ids = new IdRange[]{new IdRange(1L)};
        SearchQuery.NumericRange[] ranges = new SearchQuery.NumericRange[]{new SearchQuery.NumericRange(42L)};
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).existsCount();
                this.will(4.returnValue((Object)1L));
                ((SelectedMailbox)this.exactly(2).of((Object)SearchProcessorTest.this.selectedMailbox)).uid(this.with(4.equal((Object)1)));
                this.will(4.returnValue((Object)42L));
            }
        });
        this.allowUnsolicitedResponses();
        this.check(SearchKey.buildSequenceSet((IdRange[])ids), SearchQuery.uid((SearchQuery.NumericRange[])ranges));
    }

    @Test
    public void testALL() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildAll(), SearchQuery.all());
    }

    private void expectsGetSelectedMailbox() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((MailboxManager)this.atMost(1).of((Object)SearchProcessorTest.this.mailboxManager)).getMailbox((MailboxPath)this.with(5.equal((Object)mailboxPath)), (MailboxSession)this.with(5.same((Object)SearchProcessorTest.this.mailboxSession)));
                this.will(5.returnValue((Object)SearchProcessorTest.this.mailbox));
                ((MailboxManager)this.atMost(1).of((Object)SearchProcessorTest.this.mailboxManager)).getMailbox((MailboxPath)this.with(5.equal((Object)mailboxPath)), (MailboxSession)this.with(5.same((Object)SearchProcessorTest.this.mailboxSession)));
                this.will(5.returnValue((Object)SearchProcessorTest.this.mailbox));
                ((ImapSession)this.allowing(SearchProcessorTest.this.session)).getSelected();
                this.will(5.returnValue((Object)SearchProcessorTest.this.selectedMailbox));
                ((SelectedMailbox)this.atMost(1).of((Object)SearchProcessorTest.this.selectedMailbox)).isRecentUidRemoved();
                this.will(5.returnValue((Object)false));
                ((SelectedMailbox)this.atLeast(1).of((Object)SearchProcessorTest.this.selectedMailbox)).isSizeChanged();
                this.will(5.returnValue((Object)false));
                ((SelectedMailbox)this.atLeast(1).of((Object)SearchProcessorTest.this.selectedMailbox)).getPath();
                this.will(5.returnValue((Object)mailboxPath));
                ((SelectedMailbox)this.atMost(1).of((Object)SearchProcessorTest.this.selectedMailbox)).flagUpdateUids();
                this.will(5.returnValue((Object)Collections.EMPTY_LIST));
                ((SelectedMailbox)this.atMost(1).of((Object)SearchProcessorTest.this.selectedMailbox)).resetEvents();
                ((SelectedMailbox)this.oneOf(SearchProcessorTest.this.selectedMailbox)).getRecent();
                this.will(5.returnValue(new ArrayList()));
            }
        });
    }

    private Calendar getGMT() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.UK);
    }

    private Date getDate(int day, int month, int year) {
        Calendar cal = this.getGMT();
        cal.set(year, month - 1, day);
        return cal.getTime();
    }

    @Test
    public void testANSWERED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildAnswered(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.ANSWERED));
    }

    @Test
    public void testBCC() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildBcc((String)ADDRESS), SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)ADDRESS));
    }

    @Test
    public void testBEFORE() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildBefore((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.internalDateBefore((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
    }

    @Test
    public void testBODY() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildBody((String)SUBJECT), SearchQuery.bodyContains((String)SUBJECT));
    }

    @Test
    public void testCC() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildCc((String)ADDRESS), SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)ADDRESS));
    }

    @Test
    public void testDELETED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildDeleted(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED));
    }

    @Test
    public void testDRAFT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildDraft(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT));
    }

    @Test
    public void testFLAGGED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildFlagged(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.FLAGGED));
    }

    @Test
    public void testFROM() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildFrom((String)ADDRESS), SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)ADDRESS));
    }

    @Test
    public void testHEADER() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildHeader((String)"In-Reply-To", (String)ADDRESS), SearchQuery.headerContains((String)"In-Reply-To", (String)ADDRESS));
    }

    @Test
    public void testKEYWORD() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildKeyword((String)KEYWORD), SearchQuery.flagIsSet((String)KEYWORD));
    }

    @Test
    public void testLARGER() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildLarger((long)1729L), SearchQuery.sizeGreaterThan((long)1729L));
    }

    @Test
    public void testNEW() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildNew(), SearchQuery.and((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT), (SearchQuery.Criterion)SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN)));
    }

    @Test
    public void testNOT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildNot((SearchKey)SearchKey.buildOn((DayMonthYear)DAY_MONTH_YEAR)), SearchQuery.not((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)));
    }

    @Test
    public void testOLD() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildOld(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT));
    }

    @Test
    public void testON() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildOn((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.internalDateOn((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
    }

    @Test
    public void testAND() throws Exception {
        this.expectsGetSelectedMailbox();
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        keys.add(SearchKey.buildOn((DayMonthYear)DAY_MONTH_YEAR));
        keys.add(SearchKey.buildOld());
        keys.add(SearchKey.buildLarger((long)1729L));
        ArrayList<SearchQuery.Criterion> criteria = new ArrayList<SearchQuery.Criterion>();
        criteria.add(SearchQuery.internalDateOn((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
        criteria.add(SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT));
        criteria.add(SearchQuery.sizeGreaterThan((long)1729L));
        this.check(SearchKey.buildAnd(keys), SearchQuery.and(criteria));
    }

    @Test
    public void testOR() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildOr((SearchKey)SearchKey.buildOn((DayMonthYear)DAY_MONTH_YEAR), (SearchKey)SearchKey.buildOld()), SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT)));
    }

    @Test
    public void testRECENT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildRecent(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT));
    }

    @Test
    public void testSEEN() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSeen(), SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN));
    }

    @Test
    public void testSENTBEFORE() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSentBefore((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.headerDateBefore((String)"Date", (Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
    }

    @Test
    public void testSENTON() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSentOn((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.headerDateOn((String)"Date", (Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
    }

    @Test
    public void testSENTSINCE() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSentSince((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.or((SearchQuery.Criterion)SearchQuery.headerDateOn((String)"Date", (Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.headerDateAfter((String)"Date", (Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)));
    }

    @Test
    public void testSINCE() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSince((DayMonthYear)DAY_MONTH_YEAR), SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)this.getDate(6, 6, 1944), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day)));
    }

    @Test
    public void testSMALLER() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSmaller((long)1729L), SearchQuery.sizeLessThan((long)1729L));
    }

    @Test
    public void testSUBJECT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildSubject((String)SUBJECT), SearchQuery.headerContains((String)"Subject", (String)SUBJECT));
    }

    @Test
    public void testTEXT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildText((String)SUBJECT), SearchQuery.mailContains((String)SUBJECT));
    }

    @Test
    public void testTO() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildTo((String)ADDRESS), SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)ADDRESS));
    }

    @Test
    public void testUID() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getFirstUid();
                this.will(6.returnValue((Object)1L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getLastUid();
                this.will(6.returnValue((Object)1048L));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).existsCount();
                this.will(6.returnValue((Object)1L));
            }
        });
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUidSet((IdRange[])IDS), SearchQuery.uid((SearchQuery.NumericRange[])RANGES));
    }

    @Test
    public void testUNANSWERED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUnanswered(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.ANSWERED));
    }

    @Test
    public void testUNDELETED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUndeleted(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DELETED));
    }

    @Test
    public void testUNDRAFT() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUndraft(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT));
    }

    @Test
    public void testUNFLAGGED() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUnflagged(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.FLAGGED));
    }

    @Test
    public void testUNKEYWORD() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUnkeyword((String)KEYWORD), SearchQuery.flagIsUnSet((String)KEYWORD));
    }

    @Test
    public void testUNSEEN() throws Exception {
        this.expectsGetSelectedMailbox();
        this.check(SearchKey.buildUnseen(), SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN));
    }

    private void check(SearchKey key, SearchQuery.Criterion criterion) throws Exception {
        SearchQuery query = new SearchQuery();
        query.andCriteria(criterion);
        this.check(key, query);
    }

    private void check(SearchKey key, final SearchQuery query) throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.allowing(SearchProcessorTest.this.session)).getAttribute((String)this.with(7.equal((Object)"SEARCH_MODSEQ")));
                this.will(7.returnValue(null));
                ((ImapSession)this.allowing(SearchProcessorTest.this.session)).setAttribute("SEARCH_MODSEQ", null);
                ((ImapSession)this.allowing(SearchProcessorTest.this.session)).getAttribute((String)this.with(7.equal((Object)"org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY")));
                this.will(7.returnValue((Object)SearchProcessorTest.this.mailboxSession));
                ((ImapSession)this.allowing(SearchProcessorTest.this.session)).getLog();
                this.will(7.returnValue((Object)SearchProcessorTest.this.logger));
                ((MessageManager)this.oneOf(SearchProcessorTest.this.mailbox)).search((SearchQuery)this.with(7.equal((Object)query)), (MailboxSession)this.with(7.equal((Object)SearchProcessorTest.this.mailboxSession)));
                this.will(7.returnValue(new ArrayList().iterator()));
                ((ImapProcessor.Responder)this.oneOf(SearchProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(7.equal((Object)new SearchResponse(EMPTY, null))));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).getApplicableFlags();
                this.will(7.returnValue((Object)new Flags()));
                ((SelectedMailbox)this.allowing(SearchProcessorTest.this.selectedMailbox)).hasNewApplicableFlags();
                this.will(7.returnValue((Object)false));
            }
        });
        SearchRequest message = new SearchRequest(this.command, new SearchOperation(key, new ArrayList()), false, TAG);
        this.processor.doProcess(message, this.session, TAG, this.command, this.responder);
    }

    private void expectOk() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((StatusResponseFactory)this.oneOf(SearchProcessorTest.this.serverResponseFactory)).taggedOk((String)this.with(8.equal((Object)SearchProcessorTest.TAG)), (ImapCommand)this.with(8.same((Object)SearchProcessorTest.this.command)), (HumanReadableText)this.with(8.equal((Object)HumanReadableText.COMPLETED)));
                this.will(8.returnValue((Object)SearchProcessorTest.this.statusResponse));
                ((ImapProcessor.Responder)this.oneOf(SearchProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(8.same((Object)SearchProcessorTest.this.statusResponse)));
            }
        });
    }
}

