/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.NamespaceRequest;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.apache.james.imap.processor.NamespaceProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class NamespaceProcessorTest {
    private static final String SHARED_PREFIX = "SharedPrefix";
    private static final String USERS_PREFIX = "UsersPrefix";
    private static final String PERSONAL_PREFIX = "PersonalPrefix";
    NamespaceProcessor subject;
    StatusResponseFactory statusResponseStub;
    ImapSession imapSessionStub;
    MailboxSession mailboxSessionStub;
    String personalSpaceStub;
    String usersSpaceStub;
    String sharedSpaceStub;
    NamespaceRequest namespaceRequest;
    Collection<String> sharedSpaces;
    MailboxManager mailboxManagerStub;
    Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.sharedSpaces = new ArrayList<String>();
        this.statusResponseStub = (StatusResponseFactory)this.mockery.mock(StatusResponseFactory.class);
        this.mailboxManagerStub = (MailboxManager)this.mockery.mock(MailboxManager.class);
        this.subject = new NamespaceProcessor((ImapProcessor)this.mockery.mock(ImapProcessor.class), this.mailboxManagerStub, this.statusResponseStub);
        this.imapSessionStub = (ImapSession)this.mockery.mock(ImapSession.class);
        this.mailboxSessionStub = (MailboxSession)this.mockery.mock(MailboxSession.class);
        this.namespaceRequest = new NamespaceRequest(ImapCommand.anyStateCommand((String)"Name"), "TAG");
    }

    @Test
    public void testNamespaceResponseShouldContainPersonalAndUserSpaces() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).supportMultipleNamespaces();
                this.will(1.returnValue((Object)true));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(1.returnValue((Object)NamespaceProcessorTest.this.mailboxSessionStub));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getAttribute("ENABLED_CAPABILITIES");
                this.will(1.returnValue(null));
                this.allowing(1.any(ImapSession.class)).method("setAttribute");
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getPersonalSpace();
                this.will(1.returnValue((Object)NamespaceProcessorTest.PERSONAL_PREFIX));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getOtherUsersSpace();
                this.will(1.returnValue((Object)NamespaceProcessorTest.USERS_PREFIX));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getSharedSpaces();
                this.will(1.returnValue(new ArrayList()));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getPathDelimiter();
                this.will(1.returnValue((Object)Character.valueOf('.')));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getState();
                this.will(1.returnValue((Object)ImapSessionState.AUTHENTICATED));
                ((StatusResponseFactory)this.allowing(NamespaceProcessorTest.this.statusResponseStub)).taggedOk((String)this.with(1.any(String.class)), (ImapCommand)this.with(1.any(ImapCommand.class)), (HumanReadableText)this.with(1.any(HumanReadableText.class)), (StatusResponse.ResponseCode)this.with(1.any(StatusResponse.ResponseCode.class)));
                this.will(1.returnValue((Object)NamespaceProcessorTest.this.mockery.mock(StatusResponse.class)));
                this.ignoring(NamespaceProcessorTest.this.imapSessionStub);
                this.ignoring(NamespaceProcessorTest.this.mailboxSessionStub);
                this.ignoring(NamespaceProcessorTest.this.mailboxManagerStub);
                this.ignoring(NamespaceProcessorTest.this.statusResponseStub);
            }
        });
        NamespaceResponse response = this.buildResponse(null);
        ImapProcessor.Responder responderMock = this.expectResponse(response);
        this.subject.doProcess((ImapRequest)this.namespaceRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testNamespaceResponseShouldContainSharedSpaces() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).supportMultipleNamespaces();
                this.will(2.returnValue((Object)true));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(2.returnValue((Object)NamespaceProcessorTest.this.mailboxSessionStub));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getAttribute("ENABLED_CAPABILITIES");
                this.will(2.returnValue(null));
                this.allowing(2.any(ImapSession.class)).method("setAttribute");
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getPersonalSpace();
                this.will(2.returnValue((Object)NamespaceProcessorTest.PERSONAL_PREFIX));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getOtherUsersSpace();
                this.will(2.returnValue((Object)NamespaceProcessorTest.USERS_PREFIX));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getSharedSpaces();
                this.will(2.returnValue(Arrays.asList(NamespaceProcessorTest.SHARED_PREFIX)));
                ((MailboxSession)this.allowing(NamespaceProcessorTest.this.mailboxSessionStub)).getPathDelimiter();
                this.will(2.returnValue((Object)Character.valueOf('.')));
                ((ImapSession)this.allowing(NamespaceProcessorTest.this.imapSessionStub)).getState();
                this.will(2.returnValue((Object)ImapSessionState.AUTHENTICATED));
                ((StatusResponseFactory)this.allowing(NamespaceProcessorTest.this.statusResponseStub)).taggedOk((String)this.with(2.any(String.class)), (ImapCommand)this.with(2.any(ImapCommand.class)), (HumanReadableText)this.with(2.any(HumanReadableText.class)), (StatusResponse.ResponseCode)this.with(2.any(StatusResponse.ResponseCode.class)));
                this.will(2.returnValue((Object)NamespaceProcessorTest.this.mockery.mock(StatusResponse.class)));
                this.ignoring(NamespaceProcessorTest.this.imapSessionStub);
                this.ignoring(NamespaceProcessorTest.this.mailboxSessionStub);
                this.ignoring(NamespaceProcessorTest.this.mailboxManagerStub);
                this.ignoring(NamespaceProcessorTest.this.statusResponseStub);
            }
        });
        this.sharedSpaces.add(this.sharedSpaceStub);
        ArrayList<NamespaceResponse.Namespace> sharedSpaces = new ArrayList<NamespaceResponse.Namespace>();
        sharedSpaces.add(new NamespaceResponse.Namespace(SHARED_PREFIX, '.'));
        NamespaceResponse response = this.buildResponse(sharedSpaces);
        ImapProcessor.Responder responderMock = this.expectResponse(response);
        this.subject.doProcess((ImapRequest)this.namespaceRequest, responderMock, this.imapSessionStub);
    }

    private NamespaceResponse buildResponse(List<NamespaceResponse.Namespace> sharedSpaces) {
        ArrayList<NamespaceResponse.Namespace> personalSpaces = new ArrayList<NamespaceResponse.Namespace>();
        personalSpaces.add(new NamespaceResponse.Namespace(PERSONAL_PREFIX, '.'));
        ArrayList<NamespaceResponse.Namespace> otherUsersSpaces = new ArrayList<NamespaceResponse.Namespace>();
        otherUsersSpaces.add(new NamespaceResponse.Namespace(USERS_PREFIX, '.'));
        NamespaceResponse response = new NamespaceResponse(personalSpaces, otherUsersSpaces, sharedSpaces);
        return response;
    }

    private ImapProcessor.Responder expectResponse(final NamespaceResponse response) {
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with(3.equal((Object)response)));
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with(3.any(StatusResponse.class)));
            }
        });
        return responderMock;
    }
}

