/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.MailboxType;
import org.apache.james.imap.message.response.ListResponse;
import org.apache.james.imap.processor.ListProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class ListProcessorTest {
    ListProcessor processor;
    ImapProcessor next;
    MailboxManager manager;
    ImapProcessor.Responder responder;
    MailboxMetaData result;
    ImapSession session;
    ImapCommand command;
    StatusResponseFactory serverResponseFactory;
    MailboxPath inboxPath = new MailboxPath("", "", "INBOX");
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.serverResponseFactory = (StatusResponseFactory)this.mockery.mock(StatusResponseFactory.class);
        this.session = (ImapSession)this.mockery.mock(ImapSession.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.next = (ImapProcessor)this.mockery.mock(ImapProcessor.class);
        this.responder = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.result = (MailboxMetaData)this.mockery.mock(MailboxMetaData.class);
        this.manager = (MailboxManager)this.mockery.mock(MailboxManager.class);
        this.processor = this.createProcessor(this.next, this.manager, this.serverResponseFactory);
    }

    ListProcessor createProcessor(ImapProcessor next, MailboxManager manager, StatusResponseFactory factory) {
        return new ListProcessor(next, manager, factory);
    }

    ListResponse createResponse(boolean noinferior, boolean noselect, boolean marked, boolean unmarked, boolean hasChildren, boolean hasNoChildren, char hierarchyDelimiter, String mailboxName) {
        return new ListResponse(noinferior, noselect, marked, unmarked, hasChildren, hasNoChildren, "#private." + mailboxName, hierarchyDelimiter);
    }

    void setUpResult(final MailboxMetaData.Children children, final MailboxMetaData.Selectability selectability, final char hierarchyDelimiter, final MailboxPath path) {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((MailboxMetaData)this.oneOf(ListProcessorTest.this.result)).inferiors();
                this.will(1.returnValue((Object)children));
                ((MailboxMetaData)this.oneOf(ListProcessorTest.this.result)).getSelectability();
                this.will(1.returnValue((Object)selectability));
                ((MailboxMetaData)this.oneOf(ListProcessorTest.this.result)).getHierarchyDelimiter();
                this.will(1.returnValue((Object)Character.valueOf(hierarchyDelimiter)));
                ((MailboxMetaData)this.oneOf(ListProcessorTest.this.result)).getPath();
                this.will(1.returnValue((Object)path));
            }
        });
    }

    @Test
    public void testHasChildren() throws Exception {
        this.setUpResult(MailboxMetaData.Children.HAS_CHILDREN, MailboxMetaData.Selectability.NONE, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(2.equal((Object)ListProcessorTest.this.createResponse(false, false, false, false, true, false, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }

    @Test
    public void testHasNoChildren() throws Exception {
        this.setUpResult(MailboxMetaData.Children.HAS_NO_CHILDREN, MailboxMetaData.Selectability.NONE, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(3.equal((Object)ListProcessorTest.this.createResponse(false, false, false, false, false, true, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }

    @Test
    public void testNoInferiors() throws Exception {
        this.setUpResult(MailboxMetaData.Children.NO_INFERIORS, MailboxMetaData.Selectability.NONE, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(4.equal((Object)ListProcessorTest.this.createResponse(true, false, false, false, false, false, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }

    @Test
    public void testNoSelect() throws Exception {
        this.setUpResult(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.NOSELECT, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(5.equal((Object)ListProcessorTest.this.createResponse(false, true, false, false, false, false, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }

    @Test
    public void testUnMarked() throws Exception {
        this.setUpResult(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.UNMARKED, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(6.equal((Object)ListProcessorTest.this.createResponse(false, false, false, true, false, false, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }

    @Test
    public void testMarked() throws Exception {
        this.setUpResult(MailboxMetaData.Children.CHILDREN_ALLOWED_BUT_UNKNOWN, MailboxMetaData.Selectability.MARKED, '.', this.inboxPath);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(ListProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(7.equal((Object)ListProcessorTest.this.createResponse(false, false, true, false, false, false, '.', "INBOX"))));
            }
        });
        this.processor.processResult(this.responder, false, this.result, MailboxType.OTHER);
    }
}

