/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LsubRequest;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.processor.LSubProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class LSubProcessorTest {
    private static final String ROOT = "ROOT";
    private static final char HIERARCHY_DELIMITER = '.';
    private static final String PARENT = "ROOT.PARENT";
    private static final String CHILD_ONE = "ROOT.PARENT.CHILD_ONE";
    private static final String CHILD_TWO = "ROOT.PARENT.CHILD_TWO";
    private static final String MAILBOX_C = "C.MAILBOX";
    private static final String MAILBOX_B = "B.MAILBOX";
    private static final String MAILBOX_A = "A.MAILBOX";
    private static final String TAG = "TAG";
    LSubProcessor processor;
    ImapProcessor next;
    SubscriptionManager manager;
    ImapProcessor.Responder responder;
    MailboxMetaData result;
    ImapSession session;
    MailboxSession mailboxSession;
    StatusResponseFactory serverResponseFactory;
    StatusResponse statusResponse;
    Collection<String> subscriptions;
    ImapCommand command;
    private ImapProcessor.Responder responderImpl;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.subscriptions = new ArrayList<String>();
        this.serverResponseFactory = (StatusResponseFactory)this.mockery.mock(StatusResponseFactory.class);
        this.session = (ImapSession)this.mockery.mock(ImapSession.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.next = (ImapProcessor)this.mockery.mock(ImapProcessor.class);
        this.responder = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.result = (MailboxMetaData)this.mockery.mock(MailboxMetaData.class);
        this.statusResponse = (StatusResponse)this.mockery.mock(StatusResponse.class);
        this.responderImpl = this.responder;
        this.manager = (SubscriptionManager)this.mockery.mock(SubscriptionManager.class);
        this.mailboxSession = (MailboxSession)this.mockery.mock(MailboxSession.class);
        this.processor = new LSubProcessor(this.next, (MailboxManager)this.mockery.mock(MailboxManager.class), this.manager, this.serverResponseFactory);
    }

    @Test
    public void testHierarchy() throws Exception {
        this.subscriptions.add(MAILBOX_A);
        this.subscriptions.add(MAILBOX_B);
        this.subscriptions.add(MAILBOX_C);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.allowing(LSubProcessorTest.this.session)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(1.returnValue((Object)LSubProcessorTest.this.mailboxSession));
                ((MailboxSession)this.allowing(LSubProcessorTest.this.mailboxSession)).getPathDelimiter();
                this.will(1.returnValue((Object)Character.valueOf('.')));
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(1.equal((Object)new LSubResponse("", true, '.'))));
            }
        });
        this.expectOk();
        LsubRequest request = new LsubRequest(this.command, "", "", TAG);
        this.processor.doProcessRequest(request, this.session, TAG, this.command, this.responderImpl);
    }

    @Test
    public void testShouldRespondToRegexWithSubscribedMailboxes() throws Exception {
        this.subscriptions.add(MAILBOX_A);
        this.subscriptions.add(MAILBOX_B);
        this.subscriptions.add(MAILBOX_C);
        this.subscriptions.add(CHILD_ONE);
        this.subscriptions.add(CHILD_TWO);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(2.equal((Object)new LSubResponse(LSubProcessorTest.CHILD_ONE, false, '.'))));
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(2.equal((Object)new LSubResponse(LSubProcessorTest.CHILD_TWO, false, '.'))));
            }
        });
        this.expectSubscriptions();
        this.expectOk();
        LsubRequest request = new LsubRequest(this.command, "", "ROOT.PARENT.%", TAG);
        this.processor.doProcessRequest(request, this.session, TAG, this.command, this.responderImpl);
    }

    @Test
    public void testShouldRespondNoSelectToRegexWithParentsOfSubscribedMailboxes() throws Exception {
        this.subscriptions.add(MAILBOX_A);
        this.subscriptions.add(MAILBOX_B);
        this.subscriptions.add(MAILBOX_C);
        this.subscriptions.add(CHILD_ONE);
        this.subscriptions.add(CHILD_TWO);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(3.equal((Object)new LSubResponse(LSubProcessorTest.PARENT, true, '.'))));
            }
        });
        this.expectSubscriptions();
        this.expectOk();
        LsubRequest request = new LsubRequest(this.command, "", "ROOT.%", TAG);
        this.processor.doProcessRequest(request, this.session, TAG, this.command, this.responderImpl);
    }

    @Test
    public void testShouldRespondSelectToRegexWithParentOfSubscribedMailboxesWhenParentSubscribed() throws Exception {
        this.subscriptions.add(MAILBOX_A);
        this.subscriptions.add(MAILBOX_B);
        this.subscriptions.add(MAILBOX_C);
        this.subscriptions.add(PARENT);
        this.subscriptions.add(CHILD_ONE);
        this.subscriptions.add(CHILD_TWO);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(4.equal((Object)new LSubResponse(LSubProcessorTest.PARENT, false, '.'))));
            }
        });
        this.expectSubscriptions();
        this.expectOk();
        LsubRequest request = new LsubRequest(this.command, "", "ROOT.%", TAG);
        this.processor.doProcessRequest(request, this.session, TAG, this.command, this.responderImpl);
    }

    @Test
    public void testSelectAll() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(5.equal((Object)new LSubResponse(LSubProcessorTest.MAILBOX_A, false, '.'))));
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(5.equal((Object)new LSubResponse(LSubProcessorTest.MAILBOX_B, false, '.'))));
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(5.equal((Object)new LSubResponse(LSubProcessorTest.MAILBOX_C, false, '.'))));
            }
        });
        this.subscriptions.add(MAILBOX_A);
        this.subscriptions.add(MAILBOX_B);
        this.subscriptions.add(MAILBOX_C);
        this.expectSubscriptions();
        this.expectOk();
        LsubRequest request = new LsubRequest(this.command, "", "*", TAG);
        this.processor.doProcessRequest(request, this.session, TAG, this.command, this.responderImpl);
    }

    private void expectOk() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((StatusResponseFactory)this.oneOf(LSubProcessorTest.this.serverResponseFactory)).taggedOk((String)this.with(6.equal((Object)LSubProcessorTest.TAG)), (ImapCommand)this.with(6.same((Object)LSubProcessorTest.this.command)), (HumanReadableText)this.with(6.equal((Object)HumanReadableText.COMPLETED)));
                this.will(6.returnValue((Object)LSubProcessorTest.this.statusResponse));
                ((ImapProcessor.Responder)this.oneOf(LSubProcessorTest.this.responder)).respond((ImapResponseMessage)this.with(6.same((Object)LSubProcessorTest.this.statusResponse)));
            }
        });
    }

    private void expectSubscriptions() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapSession)this.exactly(2).of((Object)LSubProcessorTest.this.session)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(7.returnValue((Object)LSubProcessorTest.this.mailboxSession));
                ((MailboxSession)this.allowing(LSubProcessorTest.this.mailboxSession)).getPathDelimiter();
                this.will(7.returnValue((Object)Character.valueOf('.')));
                ((MailboxSession)this.oneOf(LSubProcessorTest.this.mailboxSession)).getUser();
                this.will(7.returnValue((Object)new MailboxSession.User(){

                    public List<Locale> getLocalePreferences() {
                        return new ArrayList<Locale>();
                    }

                    public String getPassword() {
                        return "test";
                    }

                    public String getUserName() {
                        return "test";
                    }
                }));
                ((SubscriptionManager)this.oneOf(LSubProcessorTest.this.manager)).subscriptions((MailboxSession)this.with(7.same((Object)LSubProcessorTest.this.mailboxSession)));
                this.will(7.returnValue(LSubProcessorTest.this.subscriptions));
            }
        });
    }
}

