/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.GetACLRequest;
import org.apache.james.imap.message.response.ACLResponse;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;
import org.apache.james.imap.processor.GetACLProcessor;
import org.apache.james.imap.processor.StatusResponseTypeMatcher;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SimpleMailboxACL;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class GetACLProcessorTest {
    private static final String MAILBOX_NAME = "INBOX";
    private static final String USER_1 = "user1";
    ImapSession imapSessionStub;
    MailboxManager mailboxManagerStub;
    MailboxSession mailboxSessionStub;
    MessageManager messageManagerStub;
    MessageManager.MetaData metaDataStub;
    Mockery mockery = new JUnit4Mockery();
    GetACLRequest getACLRequest;
    UnpooledStatusResponseFactory statusResponseFactory;
    GetACLProcessor subject;
    MailboxSession.User user1Stub;

    private Expectations prepareRightsExpectations() throws MailboxException {
        return new Expectations(){
            {
                ((ImapSession)this.allowing(GetACLProcessorTest.this.imapSessionStub)).getAttribute("org.apache.james.api.imap.MAILBOX_SESSION_ATTRIBUTE_SESSION_KEY");
                this.will(1.returnValue((Object)GetACLProcessorTest.this.mailboxSessionStub));
                ((ImapSession)this.allowing(GetACLProcessorTest.this.imapSessionStub)).getState();
                this.will(1.returnValue((Object)ImapSessionState.AUTHENTICATED));
                ((MailboxSession)this.allowing(GetACLProcessorTest.this.mailboxSessionStub)).getUser();
                this.will(1.returnValue((Object)GetACLProcessorTest.this.user1Stub));
                ((MailboxSession.User)this.allowing(GetACLProcessorTest.this.user1Stub)).getUserName();
                this.will(1.returnValue((Object)GetACLProcessorTest.USER_1));
                ((MailboxManager)this.allowing(GetACLProcessorTest.this.mailboxManagerStub)).startProcessingRequest((MailboxSession)this.with(1.same((Object)GetACLProcessorTest.this.mailboxSessionStub)));
                ((MailboxManager)this.allowing(GetACLProcessorTest.this.mailboxManagerStub)).endProcessingRequest((MailboxSession)this.with(1.same((Object)GetACLProcessorTest.this.mailboxSessionStub)));
                ((MessageManager)this.allowing(GetACLProcessorTest.this.messageManagerStub)).getMetaData(this.with(1.any(Boolean.class)), (MailboxSession)this.with(1.same((Object)GetACLProcessorTest.this.mailboxSessionStub)), (MessageManager.MetaData.FetchGroup)this.with(1.any(MessageManager.MetaData.FetchGroup.class)));
                this.will(1.returnValue((Object)GetACLProcessorTest.this.metaDataStub));
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.statusResponseFactory = new UnpooledStatusResponseFactory();
        this.mailboxManagerStub = (MailboxManager)this.mockery.mock(MailboxManager.class);
        this.subject = new GetACLProcessor((ImapProcessor)this.mockery.mock(ImapProcessor.class), this.mailboxManagerStub, (StatusResponseFactory)this.statusResponseFactory);
        this.imapSessionStub = (ImapSession)this.mockery.mock(ImapSession.class);
        this.mailboxSessionStub = (MailboxSession)this.mockery.mock(MailboxSession.class);
        this.user1Stub = (MailboxSession.User)this.mockery.mock(MailboxSession.User.class);
        this.messageManagerStub = (MessageManager)this.mockery.mock(MessageManager.class);
        this.metaDataStub = (MessageManager.MetaData)this.mockery.mock(MessageManager.MetaData.class);
        this.getACLRequest = new GetACLRequest("TAG", ImapCommand.anyStateCommand((String)"Name"), MAILBOX_NAME);
    }

    @Test
    public void testNoListRight() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)false));
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.getACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testNoAdminRight() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)false));
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.getACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testInexistentMailboxName() throws Exception {
        Expectations expectations = this.prepareRightsExpectations();
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.throwException((Throwable)new MailboxNotFoundException(MAILBOX_NAME)));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.NO)));
            }
        });
        this.subject.doProcess((ImapRequest)this.getACLRequest, responderMock, this.imapSessionStub);
    }

    @Test
    public void testSufficientRights() throws Exception {
        MailboxACL acl = SimpleMailboxACL.OWNER_FULL_ACL;
        Expectations expectations = this.prepareRightsExpectations();
        ((MailboxManager)expectations.allowing((Object)this.mailboxManagerStub)).getMailbox((MailboxPath)expectations.with(Expectations.any(MailboxPath.class)), (MailboxSession)expectations.with(Expectations.any(MailboxSession.class)));
        expectations.will(Expectations.returnValue((Object)this.messageManagerStub));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.l_Lookup_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager)expectations.allowing((Object)this.messageManagerStub)).hasRight((MailboxACL.MailboxACLRight)expectations.with(Expectations.equal((Object)SimpleMailboxACL.Rfc4314Rights.a_Administer_RIGHT)), (MailboxSession)expectations.with(Expectations.same((Object)this.mailboxSessionStub)));
        expectations.will(Expectations.returnValue((Object)true));
        ((MessageManager.MetaData)expectations.allowing((Object)this.metaDataStub)).getACL();
        expectations.will(Expectations.returnValue((Object)acl));
        this.mockery.checking((ExpectationBuilder)expectations);
        final ACLResponse response = new ACLResponse(MAILBOX_NAME, acl);
        final ImapProcessor.Responder responderMock = (ImapProcessor.Responder)this.mockery.mock(ImapProcessor.Responder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with(5.equal((Object)response)));
                ((ImapProcessor.Responder)this.oneOf(responderMock)).respond((ImapResponseMessage)this.with((Matcher)new StatusResponseTypeMatcher(StatusResponse.Type.OK)));
            }
        });
        this.subject.doProcess((ImapRequest)this.getACLRequest, responderMock, this.imapSessionStub);
    }
}

