/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.encode.AbstractTestImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.base.ByteImapResponseWriter;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.junit.Before;

public class ImapResponseComposerImplTest
extends AbstractTestImapResponseComposer {
    ImapResponseComposerImpl composer;
    ByteImapResponseWriter writer;

    @Before
    public void setUp() throws Exception {
        this.writer = new ByteImapResponseWriter();
        this.composer = new ImapResponseComposerImpl((ImapResponseWriter)this.writer);
    }

    @Override
    protected byte[] encodeListResponse(String typeName, List<String> attributes, char hierarchyDelimiter, String name) throws Exception {
        this.composer.listResponse(typeName, attributes, hierarchyDelimiter, name);
        this.composer.end();
        return this.removeCRLF(this.writer.getBytes());
    }

    @Override
    protected void clear() throws Exception {
        this.writer.clear();
    }

    @Override
    protected byte[] encodeSearchResponse(long[] ids) throws Exception {
        this.composer.searchResponse(ids);
        this.composer.end();
        return this.removeCRLF(this.writer.getBytes());
    }

    @Override
    protected byte[] encodeFlagsResponse(Flags flags) throws Exception {
        this.composer.flags(flags);
        this.composer.end();
        return this.removeCRLF(this.writer.getBytes());
    }

    @Override
    protected byte[] encodeStatusResponse(Long messages, Long recent, Long uidNext, Long uidValidity, Long unseen, String mailbox) throws Exception {
        this.composer.statusResponse(messages, recent, uidNext, uidValidity, unseen, mailbox);
        this.composer.end();
        return this.removeCRLF(this.writer.getBytes());
    }

    @Override
    protected byte[] encodeStatusResponse(String tag, ImapCommand command, String type, String responseCode, Collection<String> parameters, boolean useParens, int number, String text) throws Exception {
        this.composer.statusResponse(tag, command, type, responseCode, parameters, useParens, (long)number, text);
        this.composer.end();
        return this.removeCRLF(this.writer.getBytes());
    }

    private byte[] removeCRLF(byte[] b) {
        if (b.length > 2) {
            byte[] newB = new byte[b.length - 2];
            System.arraycopy(b, 0, newB, 0, newB.length);
            return newB;
        }
        return b;
    }
}

