/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.response.Literal;

public class ByteImapResponseWriter
implements ImapConstants,
ImapResponseWriter {
    private ByteArrayOutputStream out;
    private WritableByteChannel channel;

    public ByteImapResponseWriter() {
        this.clear();
    }

    public byte[] getBytes() throws Exception {
        this.out.flush();
        return this.out.toByteArray();
    }

    public void clear() {
        this.out = new ByteArrayOutputStream();
        this.channel = Channels.newChannel(this.out);
    }

    public void write(Literal literal) throws IOException {
        literal.writeTo(this.channel);
    }

    public void write(ByteBuffer buffer) throws IOException {
        while (this.channel.write(buffer) > 0) {
        }
    }
}

