/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ListResponseEncoder;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.message.response.ListResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchResponseEncoderTest {
    ListResponseEncoder encoder;
    ImapEncoder mockNextEncoder;
    ImapResponseComposer composer;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.encoder = new ListResponseEncoder(this.mockNextEncoder);
    }

    @Test
    public void testIsAcceptable() {
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)new ListResponse(true, true, true, true, false, false, "name", '.')));
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)new LSubResponse("name", true, '.')));
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
        Assert.assertFalse((boolean)this.encoder.isAcceptable(null));
    }

    @Test
    public void testName() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(1.equal((Object)"LIST")), (List)this.with(1.aNull(List.class)), this.with(1.equal((Object)Character.valueOf('.'))), (String)this.with(1.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(false, false, false, false, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testDelimiter() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(2.equal((Object)"LIST")), (List)this.with(2.aNull(List.class)), this.with(2.equal((Object)Character.valueOf('.'))), (String)this.with(2.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(false, false, false, false, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testAllAttributes() throws Exception {
        final String[] all = new String[]{"\\Noinferiors", "\\Noselect", "\\Marked", "\\Unmarked"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(3.equal((Object)"LIST")), (List)this.with(3.equal(Arrays.asList(all))), this.with(3.equal((Object)Character.valueOf('.'))), (String)this.with(3.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(true, true, true, true, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testNoInferiors() throws Exception {
        final String[] values = new String[]{"\\Noinferiors"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(4.equal((Object)"LIST")), (List)this.with(4.equal(Arrays.asList(values))), this.with(4.equal((Object)Character.valueOf('.'))), (String)this.with(4.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(true, false, false, false, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testNoSelect() throws Exception {
        final String[] values = new String[]{"\\Noselect"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(5.equal((Object)"LIST")), (List)this.with(5.equal(Arrays.asList(values))), this.with(5.equal((Object)Character.valueOf('.'))), (String)this.with(5.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(false, true, false, false, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testMarked() throws Exception {
        final String[] values = new String[]{"\\Marked"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(6.equal((Object)"LIST")), (List)this.with(6.equal(Arrays.asList(values))), this.with(6.equal((Object)Character.valueOf('.'))), (String)this.with(6.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(false, false, true, false, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testUnmarked() throws Exception {
        final String[] values = new String[]{"\\Unmarked"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(SearchResponseEncoderTest.this.composer)).listResponse((String)this.with(7.equal((Object)"LIST")), (List)this.with(7.equal(Arrays.asList(values))), this.with(7.equal((Object)Character.valueOf('.'))), (String)this.with(7.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new ListResponse(false, false, false, true, false, false, "INBOX.name", '.'), this.composer, (ImapSession)new FakeImapSession());
    }
}

