/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.ArrayList;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.NamespaceResponseEncoder;
import org.apache.james.imap.message.response.NamespaceResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class NamespaceResponseEncoderTest {
    ImapSession dummySession;
    ImapResponseComposer mockComposer;
    NamespaceResponseEncoder subject;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.dummySession = (ImapSession)this.context.mock(ImapSession.class);
        ImapEncoder stubNextEncoderInChain = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.subject = new NamespaceResponseEncoder(stubNextEncoderInChain);
        this.mockComposer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
    }

    @Test
    public void testOneSharedNamespaceShouldWriteNilThenPrefixThenDeliminatorThenNil() throws Exception {
        String aPrefix = "A Prefix";
        String aDeliminator = "@";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = NamespaceResponseEncoderTest.this.context.sequence("Composition order");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).untagged();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).commandName("NAMESPACE");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("A Prefix@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).end();
                this.inSequence(sequence);
            }
        });
        ArrayList<NamespaceResponse.Namespace> namespaces = new ArrayList<NamespaceResponse.Namespace>();
        namespaces.add(new NamespaceResponse.Namespace("A Prefix", "@".charAt(0)));
        this.subject.doEncode((ImapMessage)new NamespaceResponse(null, null, namespaces), this.mockComposer, this.dummySession);
    }

    @Test
    public void testOneUsersNamespaceShouldWriteNilThenPrefixThenDeliminatorThenNil() throws Exception {
        String aPrefix = "A Prefix";
        String aDeliminator = "@";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = NamespaceResponseEncoderTest.this.context.sequence("Composition order");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).untagged();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).commandName("NAMESPACE");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("A Prefix@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).end();
                this.inSequence(sequence);
            }
        });
        ArrayList<NamespaceResponse.Namespace> namespaces = new ArrayList<NamespaceResponse.Namespace>();
        namespaces.add(new NamespaceResponse.Namespace("A Prefix", "@".charAt(0)));
        this.subject.doEncode((ImapMessage)new NamespaceResponse(null, namespaces, null), this.mockComposer, this.dummySession);
    }

    @Test
    public void testOnePersonalNamespaceShouldWritePrefixThenDeliminatorThenNilNil() throws Exception {
        String aPrefix = "A Prefix";
        String aDeliminator = "@";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = NamespaceResponseEncoderTest.this.context.sequence("Composition order");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).untagged();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).commandName("NAMESPACE");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("A Prefix@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).end();
                this.inSequence(sequence);
            }
        });
        ArrayList<NamespaceResponse.Namespace> namespaces = new ArrayList<NamespaceResponse.Namespace>();
        namespaces.add(new NamespaceResponse.Namespace("A Prefix", "@".charAt(0)));
        this.subject.doEncode((ImapMessage)new NamespaceResponse(namespaces, null, null), this.mockComposer, this.dummySession);
    }

    @Test
    public void testTwoPersonalNamespaceShouldWritePrefixThenDeliminatorThenNilNil() throws Exception {
        String aPrefix = "A Prefix";
        String aDeliminator = "@";
        String anotherPrefix = "Another Prefix";
        String anotherDeliminator = "^";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = NamespaceResponseEncoderTest.this.context.sequence("Composition order");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).untagged();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).commandName("NAMESPACE");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("A Prefix@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("@");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).openParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("Another Prefix^");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).quote("^");
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).end();
                this.inSequence(sequence);
            }
        });
        ArrayList<NamespaceResponse.Namespace> namespaces = new ArrayList<NamespaceResponse.Namespace>();
        namespaces.add(new NamespaceResponse.Namespace("A Prefix", "@".charAt(0)));
        namespaces.add(new NamespaceResponse.Namespace("Another Prefix", "^".charAt(0)));
        this.subject.doEncode((ImapMessage)new NamespaceResponse(namespaces, null, null), this.mockComposer, this.dummySession);
    }

    @Test
    public void testAllNullShouldWriteAllNIL() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = NamespaceResponseEncoderTest.this.context.sequence("Composition order");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).untagged();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).commandName("NAMESPACE");
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).nil();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(NamespaceResponseEncoderTest.this.mockComposer)).end();
                this.inSequence(sequence);
            }
        });
        this.subject.doEncode((ImapMessage)new NamespaceResponse(null, null, null), this.mockComposer, this.dummySession);
    }

    @Test
    public void testNamespaceResponseIsAcceptable() throws Exception {
        Assert.assertFalse((boolean)this.subject.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
        Assert.assertTrue((boolean)this.subject.isAcceptable((ImapMessage)new NamespaceResponse(null, null, null)));
    }
}

