/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.SearchResponseEncoder;
import org.apache.james.imap.message.response.SearchResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class ListResponseEncoderTest {
    private static final long[] IDS = new long[]{1L, 4L, 9L, 16L};
    SearchResponse response;
    SearchResponseEncoder encoder;
    ImapEncoder mockNextEncoder;
    ImapResponseComposer composer;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.response = new SearchResponse(IDS);
        this.encoder = new SearchResponseEncoder(this.mockNextEncoder);
    }

    @Test
    public void testIsAcceptable() {
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)this.response));
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
        Assert.assertFalse((boolean)this.encoder.isAcceptable(null));
    }

    @Test
    public void testEncode() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(ListResponseEncoderTest.this.composer)).searchResponse((long[])this.with(1.same((Object)IDS)));
            }
        });
        this.encoder.encode((ImapMessage)this.response, this.composer, (ImapSession)new FakeImapSession());
    }
}

