/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.FetchResponseEncoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.FetchResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class FetchResponseEncoderEnvelopeTest {
    private static final String ADDRESS_ONE_HOST = "HOST";
    private static final String ADDRESS_ONE_MAILBOX = "MAILBOX";
    private static final String ADDRESS_ONE_DOMAIN_LIST = "DOMAIN LIST";
    private static final String ADDRESS_ONE_NAME = "NAME";
    private static final String ADDRESS_TWO_HOST = "2HOST";
    private static final String ADDRESS_TWO_MAILBOX = "2MAILBOX";
    private static final String ADDRESS_TWO_DOMAIN_LIST = "2DOMAIN LIST";
    private static final String ADDRESS_TWO_NAME = "2NAME";
    private static final int MSN = 100;
    private Mockery context = new JUnit4Mockery();
    Flags flags;
    ImapResponseComposer composer;
    ImapEncoder mockNextEncoder;
    FetchResponseEncoder encoder;
    ImapCommand stubCommand;
    FetchResponse message;
    FetchResponse.Envelope envelope;
    FetchResponse.Envelope.Address[] bcc;
    FetchResponse.Envelope.Address[] cc;
    String date;
    FetchResponse.Envelope.Address[] from;
    String inReplyTo;
    String messageId;
    FetchResponse.Envelope.Address[] replyTo;
    FetchResponse.Envelope.Address[] sender;
    String subject;
    FetchResponse.Envelope.Address[] to;

    @Before
    public void setUp() throws Exception {
        this.envelope = (FetchResponse.Envelope)this.context.mock(FetchResponse.Envelope.class);
        this.bcc = null;
        this.cc = null;
        this.date = null;
        this.from = null;
        this.inReplyTo = null;
        this.messageId = null;
        this.replyTo = null;
        this.sender = null;
        this.subject = null;
        this.to = null;
        this.message = new FetchResponse(100, null, null, null, null, this.envelope, null, null, null);
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.encoder = new FetchResponseEncoder(this.mockNextEncoder, false);
        this.stubCommand = ImapCommand.anyStateCommand((String)"COMMAND");
        this.flags = new Flags(Flags.Flag.DELETED);
    }

    private FetchResponse.Envelope.Address[] mockOneAddress() {
        FetchResponse.Envelope.Address[] one = new FetchResponse.Envelope.Address[]{this.mockAddress(ADDRESS_ONE_NAME, ADDRESS_ONE_DOMAIN_LIST, ADDRESS_ONE_MAILBOX, ADDRESS_ONE_HOST)};
        return one;
    }

    private FetchResponse.Envelope.Address[] mockManyAddresses() {
        FetchResponse.Envelope.Address[] many = new FetchResponse.Envelope.Address[]{this.mockAddress(ADDRESS_ONE_NAME, ADDRESS_ONE_DOMAIN_LIST, ADDRESS_ONE_MAILBOX, ADDRESS_ONE_HOST), this.mockAddress(ADDRESS_TWO_NAME, ADDRESS_TWO_DOMAIN_LIST, ADDRESS_TWO_MAILBOX, ADDRESS_TWO_HOST)};
        return many;
    }

    private FetchResponse.Envelope.Address mockAddress(final String name, final String domainList, final String mailbox, final String host) {
        final FetchResponse.Envelope.Address address = (FetchResponse.Envelope.Address)this.context.mock(FetchResponse.Envelope.Address.class, name + host);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.Envelope.Address)this.oneOf(address)).getPersonalName();
                this.will(1.returnValue((Object)name));
                ((FetchResponse.Envelope.Address)this.oneOf(address)).getAtDomainList();
                this.will(1.returnValue((Object)domainList));
                ((FetchResponse.Envelope.Address)this.oneOf(address)).getMailboxName();
                this.will(1.returnValue((Object)mailbox));
                ((FetchResponse.Envelope.Address)this.oneOf(address)).getHostName();
                this.will(1.returnValue((Object)host));
            }
        });
        return address;
    }

    private void envelopExpects() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getBcc();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.bcc));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getCc();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.cc));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getDate();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.date));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getFrom();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.from));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getInReplyTo();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.inReplyTo));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getMessageId();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.messageId));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getReplyTo();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.replyTo));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getSender();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.sender));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getSubject();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.subject));
                ((FetchResponse.Envelope)this.oneOf(FetchResponseEncoderEnvelopeTest.this.envelope)).getTo();
                this.will(2.returnValue((Object)FetchResponseEncoderEnvelopeTest.this.to));
            }
        });
    }

    @Test
    public void testShouldNilAllNullProperties() throws Exception {
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(3.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(3.aNull(String.class)), (String)this.with(3.aNull(String.class)), this.with(3.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(6).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope(null, null);
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeDate() throws Exception {
        this.date = "a date";
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(4.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(FetchResponseEncoderEnvelopeTest.this.date), (String)this.with(4.aNull(String.class)), this.with(4.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(6).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope(null, null);
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeSubject() throws Exception {
        this.subject = "some subject";
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(5.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(5.aNull(String.class)), (String)this.with(5.equal((Object)FetchResponseEncoderEnvelopeTest.this.subject)), this.with(5.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(6).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope(null, null);
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeInReplyTo() throws Exception {
        this.inReplyTo = "some reply to";
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(6.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(6.aNull(String.class)), (String)this.with(6.aNull(String.class)), this.with(6.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(6).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(6.equal((Object)FetchResponseEncoderEnvelopeTest.this.inReplyTo)), (String)this.with(6.aNull(String.class)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeMessageId() throws Exception {
        this.messageId = "some message id";
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(7.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(7.aNull(String.class)), (String)this.with(7.aNull(String.class)), this.with(7.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(6).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(7.aNull(String.class)), (String)this.with(7.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneFromAddress() throws Exception {
        this.from = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(8.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(8.aNull(String.class)), (String)this.with(8.aNull(String.class)), this.with(8.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(8.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(8.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(8.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(8.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(5).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(8.aNull(String.class)), (String)this.with(8.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManyFromAddress() throws Exception {
        this.from = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(9.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(9.aNull(String.class)), (String)this.with(9.aNull(String.class)), this.with(9.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(5).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(9.aNull(String.class)), (String)this.with(9.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneSenderAddress() throws Exception {
        this.sender = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(10.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(10.aNull(String.class)), (String)this.with(10.aNull(String.class)), this.with(10.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(1).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(10.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(10.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(10.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(10.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(4).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(10.aNull(String.class)), (String)this.with(10.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManySenderAddress() throws Exception {
        this.sender = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(11.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(11.aNull(String.class)), (String)this.with(11.aNull(String.class)), this.with(11.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(1).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(4).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(11.aNull(String.class)), (String)this.with(11.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneReplyToAddress() throws Exception {
        this.replyTo = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(12.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(12.aNull(String.class)), (String)this.with(12.aNull(String.class)), this.with(12.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(2).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(12.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(12.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(12.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(12.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(3).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(12.aNull(String.class)), (String)this.with(12.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManyReplyToAddress() throws Exception {
        this.replyTo = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(13.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(13.aNull(String.class)), (String)this.with(13.aNull(String.class)), this.with(13.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(2).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(3).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(13.aNull(String.class)), (String)this.with(13.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneToAddress() throws Exception {
        this.to = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(14.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(14.aNull(String.class)), (String)this.with(14.aNull(String.class)), this.with(14.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(3).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(14.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(14.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(14.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(14.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(2).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(14.aNull(String.class)), (String)this.with(14.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManyToAddress() throws Exception {
        this.to = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(15.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(15.aNull(String.class)), (String)this.with(15.aNull(String.class)), this.with(15.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(3).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(2).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(15.aNull(String.class)), (String)this.with(15.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneCcAddress() throws Exception {
        this.cc = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(16.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(16.aNull(String.class)), (String)this.with(16.aNull(String.class)), this.with(16.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(4).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(16.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(16.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(16.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(16.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(1).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(16.aNull(String.class)), (String)this.with(16.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManyCcAddress() throws Exception {
        this.cc = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(17.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(17.aNull(String.class)), (String)this.with(17.aNull(String.class)), this.with(17.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(4).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(1).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(17.aNull(String.class)), (String)this.with(17.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeOneBccAddress() throws Exception {
        this.bcc = this.mockOneAddress();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(18.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(18.aNull(String.class)), (String)this.with(18.aNull(String.class)), this.with(18.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(5).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(18.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(18.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(18.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(18.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(18.aNull(String.class)), (String)this.with(18.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldComposeManyBccAddress() throws Exception {
        this.bcc = this.mockManyAddresses();
        this.envelopExpects();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence composition = FetchResponseEncoderEnvelopeTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).openFetchResponse(this.with(19.equal((Object)100L)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startEnvelope((String)this.with(19.aNull(String.class)), (String)this.with(19.aNull(String.class)), this.with(19.equal((Object)true)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.exactly(5).of((Object)FetchResponseEncoderEnvelopeTest.this.composer)).nil();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).startAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_NAME)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_DOMAIN_LIST)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_MAILBOX)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_ONE_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).address((String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_NAME)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_DOMAIN_LIST)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_MAILBOX)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.ADDRESS_TWO_HOST)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endAddresses();
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).endEnvelope((String)this.with(19.aNull(String.class)), (String)this.with(19.equal((Object)FetchResponseEncoderEnvelopeTest.this.messageId)));
                this.inSequence(composition);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderEnvelopeTest.this.composer)).closeFetchResponse();
                this.inSequence(composition);
            }
        });
        this.encoder.doEncode((ImapMessage)this.message, this.composer, (ImapSession)new FakeImapSession());
    }
}

