/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestImapResponseComposer {
    private static final long[] ONE_TWO_THREE = new long[]{1L, 2L, 3L};
    private static final long[] FIBS = new long[]{1L, 1L, 2L, 3L, 5L, 8L, 13L, 21L, 34L, 65L, 99L};
    private static final long[] EMPTY = new long[0];

    @Test
    public void testSearch() throws Exception {
        this.checkSearchResponseEncode("* SEARCH 1 2 3\r\n", ONE_TWO_THREE);
        this.checkSearchResponseEncode("* SEARCH 1 1 2 3 5 8 13 21 34 65 99\r\n", FIBS);
        this.checkSearchResponseEncode("* SEARCH\r\n", EMPTY);
    }

    @Test
    public void testQuotedDelimiter() throws Exception {
        this.checkListResponseEncode("* LSUB () \"\\\"\" \"#news\"\r\n", "LSUB", null, '\"', "#news");
        this.checkListResponseEncode("* LIST () \"\\\"\" \"#INBOX\"\r\n", "LIST", null, '\"', "#INBOX");
        this.checkListResponseEncode("* LSUB () \"\\\\\" \"#news\"\r\n", "LSUB", null, '\\', "#news");
        this.checkListResponseEncode("* LIST () \"\\\\\" \"#INBOX\"\r\n", "LIST", null, '\\', "#INBOX");
    }

    @Test
    public void testNilDelimiter() throws Exception {
        this.checkListResponseEncode("* LSUB () NIL \"#news\"\r\n", "LSUB", null, '\u0000', "#news");
        this.checkListResponseEncode("* LIST () NIL \"#INBOX\"\r\n", "LIST", null, '\u0000', "#INBOX");
    }

    @Test
    public void testSimple() throws Exception {
        this.checkListResponseEncode("* LSUB () \".\" \"#news\"\r\n", "LSUB", null, '.', "#news");
        this.checkListResponseEncode("* LIST () \".\" \"#INBOX\"\r\n", "LIST", null, '.', "#INBOX");
        this.checkListResponseEncode("* LSUB () \".\" \"#news.sub\"\r\n", "LSUB", null, '.', "#news.sub");
        this.checkListResponseEncode("* LIST () \".\" \"#INBOX.sub\"\r\n", "LIST", null, '.', "#INBOX.sub");
    }

    @Test
    public void testSpecialNames() throws Exception {
        this.checkListResponseEncode("* LSUB () \"\\\\\" \"#news\\\\sub\\\\directory\"\r\n", "LSUB", null, '\\', "#news\\sub\\directory");
        this.checkListResponseEncode("* LIST () \"\\\\\" \"#INBOX\\\\sub\\\\directory\"\r\n", "LIST", null, '\\', "#INBOX\\sub\\directory");
        this.checkListResponseEncode("* LSUB () \".\" \"#news.sub directory.what\"\r\n", "LSUB", null, '.', "#news.sub directory.what");
        this.checkListResponseEncode("* LIST () \".\" \"#INBOX.sub directory.what\"\r\n", "LIST", null, '.', "#INBOX.sub directory.what");
        this.checkListResponseEncode("* LSUB () \".\" \"#news.\\\"sub directory\\\".what\"\r\n", "LSUB", null, '.', "#news.\"sub directory\".what");
        this.checkListResponseEncode("* LIST () \".\" \"#INBOX.\\\"sub directory\\\".what\"\r\n", "LIST", null, '.', "#INBOX.\"sub directory\".what");
    }

    @Test
    public void testAttributes() throws Exception {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("\\one");
        attributes.add("\\two");
        attributes.add("\\three");
        attributes.add("\\four");
        this.checkListResponseEncode("* LSUB (\\one \\two \\three \\four) \".\" \"#news\"\r\n", "LSUB", attributes, '.', "#news");
        this.checkListResponseEncode("* LIST (\\one \\two \\three \\four) \".\" \"#INBOX\"\r\n", "LIST", attributes, '.', "#INBOX");
    }

    @Test
    public void testEncodeStatus() throws Exception {
        this.checkStatusResponseEncode("* STATUS \"#INBOX.\\\"sub directory\\\".what\" (MESSAGES 3 RECENT 5 UIDNEXT 7 UIDVALIDITY 11 UNSEEN 13)\r\n", new Long(3L), new Long(5L), new Long(7L), new Long(11L), new Long(13L), "#INBOX.\"sub directory\".what");
        this.checkStatusResponseEncode("* STATUS \"#INBOX\" (MESSAGES 42)\r\n", new Long(42L), null, null, null, null, "#INBOX");
        this.checkStatusResponseEncode("* STATUS \"#INBOX\" (RECENT 42)\r\n", null, new Long(42L), null, null, null, "#INBOX");
        this.checkStatusResponseEncode("* STATUS \"#INBOX\" (UIDNEXT 42)\r\n", null, null, new Long(42L), null, null, "#INBOX");
        this.checkStatusResponseEncode("* STATUS \"#INBOX\" (UIDVALIDITY 42)\r\n", null, null, null, new Long(42L), null, "#INBOX");
        this.checkStatusResponseEncode("* STATUS \"#INBOX\" (UNSEEN 42)\r\n", null, null, null, null, new Long(42L), "#INBOX");
    }

    @Test
    public void testShouldEncodeFlagsCorrectly() throws Exception {
        this.checkFlagsEncode(" FLAGS (\\Seen)", new Flags(Flags.Flag.SEEN));
        this.checkFlagsEncode(" FLAGS (\\Recent)", new Flags(Flags.Flag.RECENT));
        this.checkFlagsEncode(" FLAGS (\\Draft)", new Flags(Flags.Flag.DRAFT));
        this.checkFlagsEncode(" FLAGS (\\Answered)", new Flags(Flags.Flag.ANSWERED));
        this.checkFlagsEncode(" FLAGS (\\Flagged)", new Flags(Flags.Flag.FLAGGED));
        this.checkFlagsEncode(" FLAGS (\\Deleted)", new Flags(Flags.Flag.DELETED));
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.ANSWERED);
        flags.add(Flags.Flag.FLAGGED);
        flags.add(Flags.Flag.DELETED);
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DRAFT);
        this.checkFlagsEncode(" FLAGS (\\Answered \\Deleted \\Draft \\Flagged \\Seen)", flags);
    }

    @Test
    public void testShouldEncodeUnparameterisedStatus() throws Exception {
        this.checkStatusResponseEncode("A1 NO [ALERT] APPEND failed\r\n", "A1", this.command("APPEND"), "NO", "ALERT", new ArrayList<String>(), true, 0, "failed");
        this.checkStatusResponseEncode("A1 BAD [TRYCREATE] SELECT whatever\r\n", "A1", this.command("SELECT"), "BAD", "TRYCREATE", new ArrayList<String>(), true, 0, "whatever");
    }

    @Test
    public void testShouldEncodeListParameterStatus() throws Exception {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("ONE");
        parameters.add("TWO");
        parameters.add("THREE");
        this.checkStatusResponseEncode("A1 NO [BADCHARSET (ONE TWO THREE)] APPEND failed\r\n", "A1", this.command("APPEND"), "NO", "BADCHARSET", parameters, true, 0, "failed");
    }

    @Test
    public void testShouldEncodeNumberParameterStatus() throws Exception {
        this.checkStatusResponseEncode("A1 NO [UIDNEXT 10] APPEND failed\r\n", "A1", this.command("APPEND"), "NO", "UIDNEXT", null, true, 10, "failed");
    }

    @Test
    public void testShouldEncodeNumberAndListParameterStatus() throws Exception {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("1:2");
        parameters.add("3:4");
        this.checkStatusResponseEncode("A1 OK [COPYUID 10 1:2 3:4] COPY completed\r\n", "A1", this.command("COPY"), "OK", "COPYUID", parameters, false, 10, "completed");
        parameters.clear();
        parameters.add("3");
        this.checkStatusResponseEncode("A1 OK [APPENDUID 10 3] APPEND completed\r\n", "A1", this.command("APPEND"), "OK", "APPENDUID", parameters, false, 10, "completed");
    }

    private void checkFlagsEncode(String expected, Flags flags) throws Exception {
        StringBuffer buffer = new StringBuffer();
        byte[] output = this.encodeFlagsResponse(flags);
        for (int i = 0; i < output.length; ++i) {
            buffer.append((char)output[i]);
        }
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        this.clear();
    }

    protected abstract byte[] encodeFlagsResponse(Flags var1) throws Exception;

    private void checkSearchResponseEncode(String expected, long[] ids) throws Exception {
        StringBuffer buffer = new StringBuffer();
        byte[] output = this.encodeSearchResponse(ids);
        for (int i = 0; i < output.length; ++i) {
            buffer.append((char)output[i]);
        }
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        this.clear();
    }

    protected abstract byte[] encodeSearchResponse(long[] var1) throws Exception;

    private void checkListResponseEncode(String expected, String typeName, List<String> attributes, char hierarchyDelimiter, String name) throws Exception {
        StringBuffer buffer = new StringBuffer();
        byte[] output = this.encodeListResponse(typeName, attributes, hierarchyDelimiter, name);
        for (int i = 0; i < output.length; ++i) {
            buffer.append((char)output[i]);
        }
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        this.clear();
    }

    protected abstract byte[] encodeListResponse(String var1, List<String> var2, char var3, String var4) throws Exception;

    private void checkStatusResponseEncode(String expected, Long messages, Long recent, Long uidNext, Long uidValidity, Long unseen, String mailbox) throws Exception {
        StringBuffer buffer = new StringBuffer();
        byte[] output = this.encodeStatusResponse(messages, recent, uidNext, uidValidity, unseen, mailbox);
        for (int i = 0; i < output.length; ++i) {
            buffer.append((char)output[i]);
        }
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        this.clear();
    }

    protected abstract byte[] encodeStatusResponse(Long var1, Long var2, Long var3, Long var4, Long var5, String var6) throws Exception;

    protected abstract void clear() throws Exception;

    protected abstract byte[] encodeStatusResponse(String var1, ImapCommand var2, String var3, String var4, Collection<String> var5, boolean var6, int var7, String var8) throws Exception;

    private void checkStatusResponseEncode(String expected, String tag, ImapCommand command, String type, String responseCode, Collection<String> parameters, boolean useParens, int number, String text) throws Exception {
        StringBuffer buffer = new StringBuffer();
        byte[] output = this.encodeStatusResponse(tag, command, type, responseCode, parameters, useParens, number, text);
        for (int i = 0; i < output.length; ++i) {
            buffer.append((char)output[i]);
        }
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        this.clear();
    }

    private ImapCommand command(String name) {
        return ImapCommand.anyStateCommand((String)name);
    }
}

