/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.StoreCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class StoreCommandParserTest {
    StoreCommandParser parser;
    ImapCommand command;
    ImapMessage message;
    private Mockery mockery = new JUnit4Mockery();
    private ImapSession session;

    @Before
    public void setUp() throws Exception {
        this.parser = new StoreCommandParser();
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.mockery.mock(ImapMessage.class);
        this.session = (ImapSession)this.mockery.mock(ImapSession.class);
    }

    @Test
    public void testShouldParseSilentDraftFlagged() throws Exception {
        IdRange[] ranges = new IdRange[]{new IdRange(1L)};
        Flags flags = new Flags();
        flags.add(Flags.Flag.DRAFT);
        flags.add(Flags.Flag.FLAGGED);
        this.check("1 FLAGS.SILENT (\\Draft \\Flagged)\r\n", ranges, true, null, flags, false, "A01");
    }

    private void check(String input, IdRange[] idSet, boolean silent, Boolean sign, Flags flags, boolean useUids, String tag) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        this.parser.decode(this.command, (ImapRequestLineReader)reader, tag, useUids, this.session);
    }
}

