/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserTopLevelAndTest {
    Input[] one = new Input[]{SearchCommandParserTopLevelAndTest.sequence()};
    Input[] base = new Input[]{SearchCommandParserTopLevelAndTest.sequence(), SearchCommandParserTopLevelAndTest.uid(), SearchCommandParserTopLevelAndTest.fromHeader(), SearchCommandParserTopLevelAndTest.since(), SearchCommandParserTopLevelAndTest.stringQuoted(), SearchCommandParserTopLevelAndTest.stringUnquoted(), SearchCommandParserTopLevelAndTest.draft()};
    Input[] variety = new Input[]{SearchCommandParserTopLevelAndTest.sequence(), SearchCommandParserTopLevelAndTest.uid(), SearchCommandParserTopLevelAndTest.fromHeader(), SearchCommandParserTopLevelAndTest.since(), SearchCommandParserTopLevelAndTest.stringQuoted(), SearchCommandParserTopLevelAndTest.stringUnquoted(), SearchCommandParserTopLevelAndTest.draft(), SearchCommandParserTopLevelAndTest.mailingListHeader(), SearchCommandParserTopLevelAndTest.on(), SearchCommandParserTopLevelAndTest.unanswered()};
    SearchCommandParser parser;
    ImapCommand command;
    ImapMessage message;
    private Mockery mockery = new JUnit4Mockery();

    public static Input sequence() {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildSequenceSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        return new Input("*:100,110,200:201,400:*", key);
    }

    public static Input uid() {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildUidSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        return new Input("UID *:100,110,200:201,400:*", key);
    }

    public static Input fromHeader() {
        SearchKey key = SearchKey.buildHeader((String)"FROM", (String)"Smith");
        return new Input("HEADER FROM Smith", key);
    }

    public static Input to() {
        SearchKey key = SearchKey.buildTo((String)"JAMES Server Development <server-dev@james.apache.org>");
        return new Input("To \"JAMES Server Development <server-dev@james.apache.org>\"", key);
    }

    public static Input mailingListHeader() {
        SearchKey key = SearchKey.buildHeader((String)"Mailing-List", (String)"contact server-dev-help@james.apache.org; run by ezmlm");
        return new Input("HEADER Mailing-List \"contact server-dev-help@james.apache.org; run by ezmlm\"", key);
    }

    public static Input since() {
        SearchKey key = SearchKey.buildSince((DayMonthYear)new DayMonthYear(11, 1, 2001));
        return new Input("since 11-Jan-2001", key);
    }

    public static Input on() {
        SearchKey key = SearchKey.buildOn((DayMonthYear)new DayMonthYear(1, 2, 2001));
        return new Input("on 1-Feb-2001", key);
    }

    public static Input stringUnquoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith");
        return new Input("FROM Smith", key);
    }

    public static Input stringQuoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith And Jones");
        return new Input("FROM \"Smith And Jones\"", key);
    }

    public static Input draft() {
        SearchKey key = SearchKey.buildDraft();
        return new Input("DRAFT", key);
    }

    public static Input unanswered() {
        SearchKey key = SearchKey.buildUnanswered();
        return new Input("unanswered", key);
    }

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.mockery.mock(ImapMessage.class);
    }

    @Test
    public void testLargePermutations() throws Exception {
        this.permute(16, this.one);
        this.permute(32, this.one);
    }

    @Test
    public void testBasePermutations() throws Exception {
        this.permute(2, this.base);
        this.permute(3, this.base);
        this.permute(4, this.base);
        this.permute(5, this.base);
    }

    @Test
    public void testVarietyPermutations() throws Exception {
        this.permute(5, this.variety);
    }

    private void permute(int mutations, Input[] inputs) throws Exception {
        this.permute(mutations, new ArrayList<SearchKey>(), new StringBuffer(), inputs);
    }

    private void permute(int mutations, List<SearchKey> keys, StringBuffer buffer, Input[] inputs) throws Exception {
        if (mutations == 0) {
            this.check(keys, buffer);
        } else {
            --mutations;
            for (int i = 0; i < inputs.length; ++i) {
                StringBuffer nextBuffer = new StringBuffer(buffer.toString());
                if (nextBuffer.length() > 0) {
                    nextBuffer.append(' ');
                }
                nextBuffer.append(inputs[i].input);
                ArrayList<SearchKey> nextKeys = new ArrayList<SearchKey>(keys);
                nextKeys.add(inputs[i].key);
                this.permute(mutations, nextKeys, nextBuffer, inputs);
            }
        }
    }

    private void check(List<SearchKey> keys, StringBuffer buffer) throws UnsupportedEncodingException, DecodingException {
        buffer.append("\r\n");
        String input = buffer.toString();
        SearchKey key = SearchKey.buildAnd(keys);
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        Assert.assertEquals((String)input, (Object)key, (Object)this.parser.decode((ImapRequestLineReader)reader));
    }

    public static final class Input {
        public String input;
        public SearchKey key;

        public Input(String input, SearchKey key) {
            this.input = input;
            this.key = key;
        }
    }
}

