/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserNotTest {
    SearchCommandParser parser;
    ImapCommand command;
    ImapMessage message;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.context.mock(ImapMessage.class);
    }

    @Test
    public void testShouldParseNotSequence() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey notdKey = SearchKey.buildSequenceSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT *:100,110,200:201,400:*\r\n", key);
    }

    @Test
    public void testShouldParseNotUid() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey notdKey = SearchKey.buildUidSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT UID *:100,110,200:201,400:*\r\n", key);
    }

    @Test
    public void testShouldParseNotHeaderKey() throws Exception {
        SearchKey notdKey = SearchKey.buildHeader((String)"FROM", (String)"Smith");
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT HEADER FROM Smith\r\n", key);
        this.checkValid("NOT header FROM Smith\r\n", key);
    }

    @Test
    public void testShouldParseNotDateParameterKey() throws Exception {
        SearchKey notdKey = SearchKey.buildSince((DayMonthYear)new DayMonthYear(11, 1, 2001));
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT since 11-Jan-2001\r\n", key);
        this.checkValid("NOT SINCE 11-Jan-2001\r\n", key);
    }

    @Test
    public void testShouldParseNotStringParameterKey() throws Exception {
        SearchKey notdKey = SearchKey.buildFrom((String)"Smith");
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT FROM Smith\r\n", key);
        this.checkValid("NOT FROM \"Smith\"\r\n", key);
    }

    @Test
    public void testShouldParseNotStringQuotedParameterKey() throws Exception {
        SearchKey notdKey = SearchKey.buildFrom((String)"Smith And Jones");
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT FROM \"Smith And Jones\"\r\n", key);
    }

    @Test
    public void testShouldParseNotNoParameterKey() throws Exception {
        SearchKey notdKey = SearchKey.buildNew();
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT NEW\r\n", key);
        this.checkValid("Not NEW\r\n", key);
        this.checkValid("not new\r\n", key);
    }

    private void checkValid(String input, SearchKey key) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        Assert.assertEquals((Object)key, (Object)this.parser.searchKey((ImapRequestLineReader)reader, null, false));
    }
}

