/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserAndParenthesesTest {
    private Mockery context = new JUnit4Mockery();
    Input[] variety = new Input[]{SearchCommandParserAndParenthesesTest.sequence(), SearchCommandParserAndParenthesesTest.uid(), SearchCommandParserAndParenthesesTest.fromHeader(), SearchCommandParserAndParenthesesTest.since(), SearchCommandParserAndParenthesesTest.stringQuoted(), SearchCommandParserAndParenthesesTest.stringUnquoted(), SearchCommandParserAndParenthesesTest.draft(), SearchCommandParserAndParenthesesTest.mailingListHeader(), SearchCommandParserAndParenthesesTest.on(), SearchCommandParserAndParenthesesTest.unanswered()};
    SearchCommandParser parser;
    ImapCommand command;
    ImapMessage message;

    public static Input and(Input[] parts, boolean parens) {
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        StringBuffer buffer = new StringBuffer();
        if (parens) {
            buffer.append("(");
        }
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(parts[i].input);
            keys.add(parts[i].key);
        }
        if (parens) {
            buffer.append(")");
        }
        Input input = new Input(buffer.toString(), SearchKey.buildAnd(keys));
        return input;
    }

    public static Input sequence() {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildSequenceSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        return new Input("*:100,110,200:201,400:*", key);
    }

    public static Input uid() {
        IdRange[] range = new IdRange[]{new IdRange(100L, Long.MAX_VALUE), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildUidSet((IdRange[])IdRange.mergeRanges(Arrays.asList(range)).toArray(new IdRange[0]));
        return new Input("UID *:100,110,200:201,400:*", key);
    }

    public static Input fromHeader() {
        SearchKey key = SearchKey.buildHeader((String)"FROM", (String)"Smith");
        return new Input("HEADER FROM Smith", key);
    }

    public static Input to() {
        SearchKey key = SearchKey.buildTo((String)"JAMES Server Development <server-dev@james.apache.org>");
        return new Input("To \"JAMES Server Development <server-dev@james.apache.org>\"", key);
    }

    public static Input mailingListHeader() {
        SearchKey key = SearchKey.buildHeader((String)"Mailing-List", (String)"contact server-dev-help@james.apache.org; run by ezmlm");
        return new Input("HEADER Mailing-List \"contact server-dev-help@james.apache.org; run by ezmlm\"", key);
    }

    public static Input since() {
        SearchKey key = SearchKey.buildSince((DayMonthYear)new DayMonthYear(11, 1, 2001));
        return new Input("since 11-Jan-2001", key);
    }

    public static Input on() {
        SearchKey key = SearchKey.buildOn((DayMonthYear)new DayMonthYear(1, 2, 2001));
        return new Input("on 1-Feb-2001", key);
    }

    public static Input stringUnquoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith");
        return new Input("FROM Smith", key);
    }

    public static Input stringQuoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith And Jones");
        return new Input("FROM \"Smith And Jones\"", key);
    }

    public static Input draft() {
        SearchKey key = SearchKey.buildDraft();
        return new Input("DRAFT", key);
    }

    public static Input unanswered() {
        SearchKey key = SearchKey.buildUnanswered();
        return new Input("unanswered", key);
    }

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.context.mock(ImapMessage.class);
    }

    @Test
    public void testShouldParseTopLevelParentheses() throws Exception {
        this.check(SearchCommandParserAndParenthesesTest.and(this.variety, true));
    }

    @Test
    public void testShouldParseDeepParentheses() throws Exception {
        Input[] deep = new Input[]{SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.sequence(), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.draft(), SearchCommandParserAndParenthesesTest.mailingListHeader()};
        Input[] mid = new Input[]{SearchCommandParserAndParenthesesTest.and(deep, true), SearchCommandParserAndParenthesesTest.since(), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.unanswered()};
        Input[] top = new Input[]{SearchCommandParserAndParenthesesTest.uid(), SearchCommandParserAndParenthesesTest.and(deep, true), SearchCommandParserAndParenthesesTest.and(mid, true), SearchCommandParserAndParenthesesTest.stringQuoted(), SearchCommandParserAndParenthesesTest.and(mid, true)};
        this.check(SearchCommandParserAndParenthesesTest.and(top, true));
    }

    @Test
    public void testShouldParseParenthesesOnTopLevel() throws Exception {
        Input[] deep = new Input[]{SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.sequence(), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.draft(), SearchCommandParserAndParenthesesTest.mailingListHeader()};
        Input[] mid = new Input[]{SearchCommandParserAndParenthesesTest.and(deep, true), SearchCommandParserAndParenthesesTest.since(), SearchCommandParserAndParenthesesTest.and(this.variety, true), SearchCommandParserAndParenthesesTest.unanswered()};
        Input[] top = new Input[]{SearchCommandParserAndParenthesesTest.uid(), SearchCommandParserAndParenthesesTest.and(deep, true), SearchCommandParserAndParenthesesTest.and(mid, true), SearchCommandParserAndParenthesesTest.stringQuoted(), SearchCommandParserAndParenthesesTest.and(mid, true)};
        this.check(SearchCommandParserAndParenthesesTest.and(top, false));
    }

    private void check(Input in) throws UnsupportedEncodingException, DecodingException {
        String input = in.input + "\r\n";
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        SearchKey result = this.parser.decode((ImapRequestLineReader)reader);
        Assert.assertEquals((Object)in.key, (Object)result);
    }

    public static final class Input {
        public String input;
        public SearchKey key;

        public Input(String input, SearchKey key) {
            this.input = input;
            this.key = key;
        }
    }
}

