/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.junit.Assert;
import org.junit.Test;

public class IdRangeParseTest {
    @Test
    public void testRangeInRandomOrder() throws DecodingException {
        int val1 = 1;
        int val2 = 3;
        IdRange[] ranges1 = this.ranges(this.rangeAsString(val1, val2));
        Assert.assertEquals((long)1L, (long)ranges1.length);
        Assert.assertEquals((long)val1, (long)ranges1[0].getLowVal());
        Assert.assertEquals((long)val2, (long)ranges1[0].getHighVal());
        IdRange[] ranges2 = this.ranges(this.rangeAsString(val2, val1));
        Assert.assertEquals((long)1L, (long)ranges2.length);
        Assert.assertEquals((long)val1, (long)ranges2[0].getLowVal());
        Assert.assertEquals((long)val2, (long)ranges2[0].getHighVal());
    }

    @Test
    public void testRangeUnsigned() throws DecodingException {
        int val1 = 1;
        try {
            this.ranges(this.rangeAsString(0L, val1));
            junit.framework.Assert.fail();
        }
        catch (DecodingException e) {
            // empty catch block
        }
        try {
            this.ranges(this.rangeAsString(Long.MAX_VALUE, val1));
            junit.framework.Assert.fail();
        }
        catch (DecodingException e) {
            // empty catch block
        }
        IdRange[] ranges2 = this.ranges(this.rangeAsString(1L, 0xFFFFFFFFL));
        Assert.assertEquals((long)1L, (long)ranges2.length);
        Assert.assertEquals((long)1L, (long)ranges2[0].getLowVal());
        Assert.assertEquals((long)0xFFFFFFFFL, (long)ranges2[0].getHighVal());
    }

    private String rangeAsString(long val1, long val2) {
        return val1 + ":" + val2;
    }

    private IdRange[] ranges(String rangesAsString) throws DecodingException {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream((rangesAsString + "\r\n").getBytes()), (OutputStream)new ByteArrayOutputStream());
        return reader.parseIdRange();
    }
}

