/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.FetchPartPathDecoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FetchPartPathDecoderTest {
    FetchPartPathDecoder decoder;

    @Before
    public void setUp() throws Exception {
        this.decoder = new FetchPartPathDecoder();
    }

    @Test
    public void testShouldDetectText() throws Exception {
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"TEXT"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"3.TEXT"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"3.1.TEXT"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"3.2.5.7.8.TEXT"));
    }

    @Test
    public void testShouldDetectHeader() throws Exception {
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"HEADER"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"4.HEADER"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"10.1.HEADER"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"8.3.5.11.HEADER"));
    }

    @Test
    public void testShouldDetectHeaderFields() throws Exception {
        Assert.assertEquals((long)3L, (long)this.decoder.decode((CharSequence)"HEADER.FIELDS ()"));
        Assert.assertEquals((long)3L, (long)this.decoder.decode((CharSequence)"4.HEADER.FIELDS ()"));
        Assert.assertEquals((long)3L, (long)this.decoder.decode((CharSequence)"10.1.HEADER.FIELDS ()"));
        Assert.assertEquals((long)3L, (long)this.decoder.decode((CharSequence)"8.3.5.11.HEADER.FIELDS ()"));
    }

    @Test
    public void testShouldDetectHeaderFieldsNot() throws Exception {
        Assert.assertEquals((long)4L, (long)this.decoder.decode((CharSequence)"HEADER.FIELDS.NOT ()"));
        Assert.assertEquals((long)4L, (long)this.decoder.decode((CharSequence)"4.HEADER.FIELDS.NOT ()"));
        Assert.assertEquals((long)4L, (long)this.decoder.decode((CharSequence)"10.1.HEADER.FIELDS.NOT ()"));
        Assert.assertEquals((long)4L, (long)this.decoder.decode((CharSequence)"8.3.5.11.HEADER.FIELDS.NOT ()"));
    }

    @Test
    public void testShouldDetectMime() throws Exception {
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"MIME"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"6.MIME"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"2.88.MIME"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"32.3.15.11.MIME"));
    }

    @Test
    public void testShouldDetectContent() throws Exception {
        Assert.assertEquals((long)5L, (long)this.decoder.decode((CharSequence)"34"));
        Assert.assertEquals((long)5L, (long)this.decoder.decode((CharSequence)"6"));
        Assert.assertEquals((long)5L, (long)this.decoder.decode((CharSequence)"9.88"));
        Assert.assertEquals((long)5L, (long)this.decoder.decode((CharSequence)"17.3.15.11"));
    }

    @Test
    public void testShouldIgnoreCase() throws Exception {
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"6.MIME"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"6.mime"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"6.miME"));
        Assert.assertEquals((long)1L, (long)this.decoder.decode((CharSequence)"6.MIme"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"6.HEADER"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"6.header"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"6.HEadER"));
        Assert.assertEquals((long)2L, (long)this.decoder.decode((CharSequence)"6.heADEr"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"6.TEXT"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"6.text"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"6.TExt"));
        Assert.assertEquals((long)0L, (long)this.decoder.decode((CharSequence)"6.teXT"));
    }

    @Test
    public void testMimimalPath() throws Exception {
        int[] values = new int[]{6};
        this.checkEndingPermutations(values);
    }

    @Test
    public void testLongPath() throws Exception {
        int[] values = new int[]{3, 11, 345, 231, 11, 3, 1, 1, 1, 3, 8, 8};
        this.checkEndingPermutations(values);
    }

    @Test
    public void testShouldThrowProtocolExceptionWhenSpecifierBogus() throws Exception {
        try {
            this.decoder.decode((CharSequence)"1.34.BOGUS");
            Assert.fail((String)"Expected protocol exception to be thrown");
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }

    @Test
    public void testShouldThrowProtocolExceptionWhenPathBogus() throws Exception {
        try {
            this.decoder.decode((CharSequence)"1.34.BOGUS.44.34234.324");
            Assert.fail((String)"Expected protocol exception to be thrown");
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }

    @Test
    public void testShouldReadShortFieldNames() throws Exception {
        String[] names = new String[]{"A", "B", "C", "D", "E", "F"};
        this.checkReadNames("1.8.HEADER.FIELDS", names);
    }

    @Test
    public void testShouldReadShortFieldNotNames() throws Exception {
        String[] names = new String[]{"A", "B", "C", "D", "E", "F"};
        this.checkReadNames("1.8.9.HEADER.FIELDS.NOT", names);
    }

    @Test
    public void testShouldReadOneFieldNames() throws Exception {
        String[] names = new String[]{"AFieldName"};
        this.checkReadNames("1.8.HEADER.FIELDS", names);
    }

    @Test
    public void testShouldReadOneFieldNotNames() throws Exception {
        String[] names = new String[]{"AFieldName"};
        this.checkReadNames("1.8.9.HEADER.FIELDS.NOT", names);
    }

    @Test
    public void testShouldReadManyFieldNames() throws Exception {
        String[] names = new String[]{"ONE", "TWO", "THREE", "FOUR", "FIVE", "345345"};
        this.checkReadNames("1.8.HEADER.FIELDS", names);
    }

    @Test
    public void testShouldReadManyFieldNotNames() throws Exception {
        String[] names = new String[]{"ONE", "TWO", "THREE", "FOUR", "FIVE", "345345"};
        this.checkReadNames("1.8.HEADER.FIELDS.NOT", names);
    }

    private void checkReadNames(String base, String[] names) throws Exception {
        base = base + " (";
        for (int i = 0; i < names.length; ++i) {
            base = base + ' ' + names[i];
        }
        base = base + ')';
        this.decoder.decode((CharSequence)base);
        List results = this.decoder.getNames();
        Assert.assertNotNull((Object)results);
        Iterator it = results.iterator();
        for (int i = 0; i < names.length; ++i) {
            Assert.assertEquals((Object)names[i], it.next());
        }
    }

    private void checkEndingPermutations(int[] values) throws Exception {
        String base = "";
        boolean first = true;
        for (int i = 0; i < values.length; ++i) {
            if (first) {
                first = false;
            } else {
                base = base + ".";
            }
            base = base + values[i];
        }
        this.checkPath(values, base);
        this.checkPath(values, base + ".TEXT");
        this.checkPath(values, base + ".HEADER");
        this.checkPath(values, base + ".MIME");
        this.checkPath(values, base + ".HEADER.FIELDS.NOT ()");
        this.checkPath(values, base + ".HEADER.FIELDS ()");
    }

    private void checkPath(int[] expected, String encoded) throws Exception {
        this.decoder.decode((CharSequence)encoded);
        int[] path = this.decoder.getPath();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((long)expected.length, (long)path.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)path[i]);
        }
    }
}

