/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.Flags;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.james.imap.decode.DecoderUtils;
import org.apache.james.imap.decode.DecodingException;
import org.junit.Assert;
import org.junit.Test;

public class DecoderUtilsTest {
    private static final String EXTENSION_FLAG = "\\Extension";
    private static final String A_CUSTOM_FLAG = "Another";
    private static final String FLAG_MESSAGE = "RFC3501 specifies that \\Recent flag cannot be set by the client but accept liberally for better compatibility.";

    @Test
    public void testSetRecentFlag() throws Exception {
        Flags flags = new Flags();
        DecoderUtils.setFlag((String)"\\Recent", (Flags)flags);
        Assert.assertFalse((String)FLAG_MESSAGE, (boolean)flags.contains("\\Recent"));
        Assert.assertFalse((String)FLAG_MESSAGE, (boolean)flags.contains(Flags.Flag.RECENT));
    }

    @Test
    public void testSetOtherFlag() throws Exception {
        Flags flags = new Flags();
        DecoderUtils.setFlag((String)A_CUSTOM_FLAG, (Flags)flags);
        Assert.assertTrue((String)"Unknown flags should be added", (boolean)flags.contains(A_CUSTOM_FLAG));
    }

    @Test
    public void testExtensionFlag() throws Exception {
        Flags flags = new Flags();
        DecoderUtils.setFlag((String)EXTENSION_FLAG, (Flags)flags);
        Assert.assertTrue((String)"Extension flags should be added", (boolean)flags.contains(EXTENSION_FLAG));
    }

    @Test
    public void testBadDateTime() throws Exception {
        this.checkDateTime(null);
        this.checkDateTime("");
        this.checkDateTime("This is a string long enough to be too big");
        this.checkDateTime("1");
        this.checkDateTime("12");
        this.checkDateTime("123");
        this.checkDateTime("1234");
        this.checkDateTime("12345");
        this.checkDateTime("123456");
        this.checkDateTime("1234567");
        this.checkDateTime("12345678");
        this.checkDateTime("123456789");
        this.checkDateTime("1234567890");
        this.checkDateTime("12345678901");
        this.checkDateTime("123456789012");
        this.checkDateTime("1234567890123");
        this.checkDateTime("12345678901234");
        this.checkDateTime("123456789012345");
        this.checkDateTime("1234567890123456");
        this.checkDateTime("12345678901234567");
        this.checkDateTime("123456789012345678");
        this.checkDateTime("1234567890123456789");
        this.checkDateTime("12345678901234567890");
        this.checkDateTime("123456789012345678901");
        this.checkDateTime("1234567890123456789012");
        this.checkDateTime("12345678901234567890123");
        this.checkDateTime("123456789012345678901234");
        this.checkDateTime("1234567890123456789012345");
        this.checkDateTime("12345678901234567890123456");
        this.checkDateTime("123456789012345678901234567");
    }

    private void checkDateTime(String datetime) throws Exception {
        try {
            DecoderUtils.decodeDateTime((CharSequence)datetime);
            Assert.fail((String)("Bad date-time" + datetime));
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleDecodeDateTime() throws Exception {
        Assert.assertEquals((Object)"21 Oct 1972 20:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0000").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 19:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0100").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 18:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0200").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 17:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0300").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 16:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0400").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 15:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0500").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 14:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0600").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 13:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0700").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 12:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0800").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 11:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0900").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 10:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +1000").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 09:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +1100").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 08:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +1200").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 10:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +1000").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 21:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0100").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 22:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0200").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 23:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0300").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 00:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0400").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 01:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0500").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 02:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0600").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 03:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0700").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 04:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0800").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 05:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0900").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 06:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -1000").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 19:30:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 +0030").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 20:30:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -0030").toGMTString());
        Assert.assertEquals((Object)"22 Oct 1972 06:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 20:00:00 -1000").toGMTString());
        Assert.assertEquals((Object)"20 Oct 1972 20:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 06:00:00 +1000").toGMTString());
        Assert.assertEquals((Object)"21 Oct 1972 16:00:00 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"21-Oct-1972 06:00:00 -1000").toGMTString());
    }

    @Test
    public void testAppleMailPrependsZeroNotSpace() throws Exception {
        Assert.assertEquals((Object)"9 Apr 2008 13:17:51 GMT", (Object)DecoderUtils.decodeDateTime((CharSequence)"09-Apr-2008 15:17:51 +0200").toGMTString());
    }

    @Test
    public void testDecodeDateTime() throws Exception {
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+0"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+1"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-1"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+2"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-2"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+3"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-3"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+11"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-11"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+1030"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-1030"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT+0045"));
        this.runTimeZoneTest(TimeZone.getTimeZone("GMT-0045"));
    }

    private void runTimeZoneTest(TimeZone zone) throws Exception {
        this.runDecodeDateTimeTest(new Date(10000000L), zone);
        this.runDecodeDateTimeTest(new Date(100000000L), zone);
        this.runDecodeDateTimeTest(new Date(1000000000L), zone);
        this.runDecodeDateTimeTest(new Date(10000000000L), zone);
        this.runDecodeDateTimeTest(new Date(100000000000L), zone);
        this.runDecodeDateTimeTest(new Date(1000000000000L), zone);
        this.runDecodeDateTimeTest(new Date(1194168899658L), zone);
        this.runDecodeDateTimeTest(new Date(1912093499271L), zone);
        this.runDecodeDateTimeTest(new Date(1526720308423L), zone);
        this.runDecodeDateTimeTest(new Date(1487487260757L), zone);
        this.runDecodeDateTimeTest(new Date(1584040720026L), zone);
        this.runDecodeDateTimeTest(new Date(1983293490921L), zone);
        this.runDecodeDateTimeTest(new Date(1179806572669L), zone);
        this.runDecodeDateTimeTest(new Date(1194038035064L), zone);
        this.runDecodeDateTimeTest(new Date(1057865248366L), zone);
        this.runDecodeDateTimeTest(new Date(1052797936633L), zone);
        this.runDecodeDateTimeTest(new Date(1075268253439L), zone);
        this.runDecodeDateTimeTest(new Date(1033938440306L), zone);
        this.runDecodeDateTimeTest(new Date(1031614051298L), zone);
        this.runDecodeDateTimeTest(new Date(1059929345305L), zone);
        this.runDecodeDateTimeTest(new Date(1162582627756L), zone);
        this.runDecodeDateTimeTest(new Date(1185747232134L), zone);
        this.runDecodeDateTimeTest(new Date(1151301821303L), zone);
        this.runDecodeDateTimeTest(new Date(1116091684805L), zone);
        this.runDecodeDateTimeTest(new Date(1159599194961L), zone);
        this.runDecodeDateTimeTest(new Date(1222523245646L), zone);
        this.runDecodeDateTimeTest(new Date(1219556266559L), zone);
        this.runDecodeDateTimeTest(new Date(1290015730272L), zone);
        this.runDecodeDateTimeTest(new Date(1221694598854L), zone);
        this.runDecodeDateTimeTest(new Date(1212132783343L), zone);
        this.runDecodeDateTimeTest(new Date(1221761134897L), zone);
        this.runDecodeDateTimeTest(new Date(1270941981377L), zone);
        this.runDecodeDateTimeTest(new Date(1224491731327L), zone);
        this.runDecodeDateTimeTest(new Date(1268571556436L), zone);
        this.runDecodeDateTimeTest(new Date(1246838821081L), zone);
        this.runDecodeDateTimeTest(new Date(1226795970848L), zone);
        this.runDecodeDateTimeTest(new Date(1260254185119L), zone);
    }

    private void runDecodeDateTimeTest(Date date, TimeZone zone) throws Exception {
        this.dateDecode(this.formatAsImap(date, zone), zone);
    }

    private void dateDecode(String in, TimeZone zone) throws Exception {
        Date date = DecoderUtils.decodeDateTime((CharSequence)in);
        String out = this.formatAsImap(date, zone);
        Assert.assertEquals((String)"Round trip", (Object)in, (Object)out);
    }

    private String formatAsImap(Date date, TimeZone zone) {
        Assert.assertNotNull((Object)date);
        FastDateFormat format = FastDateFormat.getInstance((String)"dd-MMM-yyyy hh:mm:ss Z", (TimeZone)zone, (Locale)Locale.US);
        String out = format.format(date);
        if (out.charAt(0) == '0') {
            out = ' ' + out.substring(1, out.length());
        }
        return out;
    }

    @Test
    public void testDecodeDigit() throws Exception {
        Assert.assertEquals((long)0L, (long)DecoderUtils.decodeDigit((char)'0'));
        Assert.assertEquals((long)1L, (long)DecoderUtils.decodeDigit((char)'1'));
        Assert.assertEquals((long)2L, (long)DecoderUtils.decodeDigit((char)'2'));
        Assert.assertEquals((long)3L, (long)DecoderUtils.decodeDigit((char)'3'));
        Assert.assertEquals((long)4L, (long)DecoderUtils.decodeDigit((char)'4'));
        Assert.assertEquals((long)5L, (long)DecoderUtils.decodeDigit((char)'5'));
        Assert.assertEquals((long)6L, (long)DecoderUtils.decodeDigit((char)'6'));
        Assert.assertEquals((long)7L, (long)DecoderUtils.decodeDigit((char)'7'));
        Assert.assertEquals((long)8L, (long)DecoderUtils.decodeDigit((char)'8'));
        Assert.assertEquals((long)9L, (long)DecoderUtils.decodeDigit((char)'9'));
        try {
            DecoderUtils.decodeDigit((char)'/');
            Assert.fail((String)"/ is not a digit");
        }
        catch (DecodingException e) {
            // empty catch block
        }
        try {
            DecoderUtils.decodeDigit((char)':');
            Assert.fail((String)": is not a digit");
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeMonth() throws Exception {
        Assert.assertEquals((long)0L, (long)DecoderUtils.decodeMonth((char)'J', (char)'A', (char)'N'));
        Assert.assertEquals((long)0L, (long)DecoderUtils.decodeMonth((char)'j', (char)'a', (char)'n'));
        Assert.assertEquals((long)1L, (long)DecoderUtils.decodeMonth((char)'F', (char)'E', (char)'B'));
        Assert.assertEquals((long)1L, (long)DecoderUtils.decodeMonth((char)'f', (char)'e', (char)'b'));
        Assert.assertEquals((long)2L, (long)DecoderUtils.decodeMonth((char)'M', (char)'A', (char)'R'));
        Assert.assertEquals((long)2L, (long)DecoderUtils.decodeMonth((char)'m', (char)'a', (char)'r'));
        Assert.assertEquals((long)3L, (long)DecoderUtils.decodeMonth((char)'A', (char)'P', (char)'R'));
        Assert.assertEquals((long)3L, (long)DecoderUtils.decodeMonth((char)'a', (char)'p', (char)'r'));
        Assert.assertEquals((long)4L, (long)DecoderUtils.decodeMonth((char)'M', (char)'A', (char)'Y'));
        Assert.assertEquals((long)4L, (long)DecoderUtils.decodeMonth((char)'m', (char)'a', (char)'y'));
        Assert.assertEquals((long)5L, (long)DecoderUtils.decodeMonth((char)'J', (char)'U', (char)'N'));
        Assert.assertEquals((long)5L, (long)DecoderUtils.decodeMonth((char)'j', (char)'u', (char)'n'));
        Assert.assertEquals((long)6L, (long)DecoderUtils.decodeMonth((char)'J', (char)'U', (char)'L'));
        Assert.assertEquals((long)6L, (long)DecoderUtils.decodeMonth((char)'j', (char)'u', (char)'l'));
        Assert.assertEquals((long)7L, (long)DecoderUtils.decodeMonth((char)'A', (char)'U', (char)'G'));
        Assert.assertEquals((long)7L, (long)DecoderUtils.decodeMonth((char)'a', (char)'u', (char)'g'));
        Assert.assertEquals((long)8L, (long)DecoderUtils.decodeMonth((char)'S', (char)'E', (char)'P'));
        Assert.assertEquals((long)8L, (long)DecoderUtils.decodeMonth((char)'s', (char)'e', (char)'p'));
        Assert.assertEquals((long)9L, (long)DecoderUtils.decodeMonth((char)'O', (char)'C', (char)'T'));
        Assert.assertEquals((long)9L, (long)DecoderUtils.decodeMonth((char)'o', (char)'c', (char)'t'));
        Assert.assertEquals((long)10L, (long)DecoderUtils.decodeMonth((char)'N', (char)'O', (char)'V'));
        Assert.assertEquals((long)10L, (long)DecoderUtils.decodeMonth((char)'n', (char)'o', (char)'v'));
        Assert.assertEquals((long)11L, (long)DecoderUtils.decodeMonth((char)'D', (char)'E', (char)'C'));
        Assert.assertEquals((long)11L, (long)DecoderUtils.decodeMonth((char)'d', (char)'e', (char)'c'));
    }

    @Test
    public void testRejectBogusMonths() throws Exception {
        this.checkReject('N', 'O', 'C');
        this.checkReject('A', 'N', 'T');
        this.checkReject('Z', 'Z', 'Z');
        this.checkReject('S', 'I', 'P');
        this.checkReject('D', 'E', 'P');
    }

    private void checkReject(char one, char two, char three) {
        try {
            DecoderUtils.decodeMonth((char)one, (char)two, (char)three);
            Assert.fail((String)(one + two + three + "is not a month"));
        }
        catch (DecodingException e) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeYear() throws Exception {
        Assert.assertEquals((long)1999L, (long)DecoderUtils.decodeYear((char)'1', (char)'9', (char)'9', (char)'9'));
        Assert.assertEquals((long)747L, (long)DecoderUtils.decodeYear((char)'0', (char)'7', (char)'4', (char)'7'));
        Assert.assertEquals((long)2525L, (long)DecoderUtils.decodeYear((char)'2', (char)'5', (char)'2', (char)'5'));
        Assert.assertEquals((long)5678L, (long)DecoderUtils.decodeYear((char)'5', (char)'6', (char)'7', (char)'8'));
        Assert.assertEquals((long)2453L, (long)DecoderUtils.decodeYear((char)'2', (char)'4', (char)'5', (char)'3'));
        Assert.assertEquals((long)2000L, (long)DecoderUtils.decodeYear((char)'2', (char)'0', (char)'0', (char)'0'));
        Assert.assertEquals((long)2007L, (long)DecoderUtils.decodeYear((char)'2', (char)'0', (char)'0', (char)'7'));
        Assert.assertEquals((long)2008L, (long)DecoderUtils.decodeYear((char)'2', (char)'0', (char)'0', (char)'8'));
        Assert.assertEquals((long)2010L, (long)DecoderUtils.decodeYear((char)'2', (char)'0', (char)'1', (char)'0'));
        Assert.assertEquals((long)2020L, (long)DecoderUtils.decodeYear((char)'2', (char)'0', (char)'2', (char)'0'));
    }

    @Test
    public void testRejectBogusYear() throws Exception {
        this.checkRejectYear('D', '0', '2', '3');
        this.checkRejectYear('1', 'A', '2', '3');
        this.checkRejectYear('1', '5', 'B', '3');
        this.checkRejectYear('9', '8', '2', 'C');
        this.checkRejectYear('S', 'A', 'F', 'd');
    }

    private void checkRejectYear(char one, char two, char three, char four) {
        try {
            DecoderUtils.decodeYear((char)one, (char)two, (char)three, (char)four);
            Assert.fail((String)(one + two + three + four + "is not a month"));
        }
        catch (DecodingException e) {
            // empty catch block
        }
    }

    @Test
    public void testDecodeZone() throws Exception {
        Assert.assertEquals((long)0L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'0', (char)'0', (char)'0'));
        Assert.assertEquals((long)100L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'1', (char)'0', (char)'0'));
        Assert.assertEquals((long)200L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'2', (char)'0', (char)'0'));
        Assert.assertEquals((long)300L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'3', (char)'0', (char)'0'));
        Assert.assertEquals((long)400L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'4', (char)'0', (char)'0'));
        Assert.assertEquals((long)500L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'5', (char)'0', (char)'0'));
        Assert.assertEquals((long)600L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'6', (char)'0', (char)'0'));
        Assert.assertEquals((long)700L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'7', (char)'0', (char)'0'));
        Assert.assertEquals((long)800L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'8', (char)'0', (char)'0'));
        Assert.assertEquals((long)900L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'9', (char)'0', (char)'0'));
        Assert.assertEquals((long)1000L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'0', (char)'0', (char)'0'));
        Assert.assertEquals((long)1100L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'1', (char)'0', (char)'0'));
        Assert.assertEquals((long)1200L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'2', (char)'0', (char)'0'));
        Assert.assertEquals((long)30L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'0', (char)'3', (char)'0'));
        Assert.assertEquals((long)130L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'1', (char)'3', (char)'0'));
        Assert.assertEquals((long)230L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'2', (char)'3', (char)'0'));
        Assert.assertEquals((long)330L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'3', (char)'3', (char)'0'));
        Assert.assertEquals((long)430L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'4', (char)'3', (char)'0'));
        Assert.assertEquals((long)530L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'5', (char)'3', (char)'0'));
        Assert.assertEquals((long)630L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'6', (char)'3', (char)'0'));
        Assert.assertEquals((long)730L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'7', (char)'3', (char)'0'));
        Assert.assertEquals((long)830L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'8', (char)'3', (char)'0'));
        Assert.assertEquals((long)930L, (long)DecoderUtils.decodeZone((char)'+', (char)'0', (char)'9', (char)'3', (char)'0'));
        Assert.assertEquals((long)1030L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'0', (char)'3', (char)'0'));
        Assert.assertEquals((long)1130L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'1', (char)'3', (char)'0'));
        Assert.assertEquals((long)1111L, (long)DecoderUtils.decodeZone((char)'+', (char)'1', (char)'1', (char)'1', (char)'1'));
        Assert.assertEquals((long)0L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'0', (char)'0', (char)'0'));
        Assert.assertEquals((long)-100L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'1', (char)'0', (char)'0'));
        Assert.assertEquals((long)-200L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'2', (char)'0', (char)'0'));
        Assert.assertEquals((long)-300L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'3', (char)'0', (char)'0'));
        Assert.assertEquals((long)-400L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'4', (char)'0', (char)'0'));
        Assert.assertEquals((long)-500L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'5', (char)'0', (char)'0'));
        Assert.assertEquals((long)-600L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'6', (char)'0', (char)'0'));
        Assert.assertEquals((long)-700L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'7', (char)'0', (char)'0'));
        Assert.assertEquals((long)-800L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'8', (char)'0', (char)'0'));
        Assert.assertEquals((long)-900L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'9', (char)'0', (char)'0'));
        Assert.assertEquals((long)-1000L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'0', (char)'0', (char)'0'));
        Assert.assertEquals((long)-1100L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'1', (char)'0', (char)'0'));
        Assert.assertEquals((long)-1200L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'2', (char)'0', (char)'0'));
        Assert.assertEquals((long)-30L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'0', (char)'3', (char)'0'));
        Assert.assertEquals((long)-130L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'1', (char)'3', (char)'0'));
        Assert.assertEquals((long)-230L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'2', (char)'3', (char)'0'));
        Assert.assertEquals((long)-330L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'3', (char)'3', (char)'0'));
        Assert.assertEquals((long)-430L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'4', (char)'3', (char)'0'));
        Assert.assertEquals((long)-530L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'5', (char)'3', (char)'0'));
        Assert.assertEquals((long)-630L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'6', (char)'3', (char)'0'));
        Assert.assertEquals((long)-730L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'7', (char)'3', (char)'0'));
        Assert.assertEquals((long)-830L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'8', (char)'3', (char)'0'));
        Assert.assertEquals((long)-930L, (long)DecoderUtils.decodeZone((char)'-', (char)'0', (char)'9', (char)'3', (char)'0'));
        Assert.assertEquals((long)-1030L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'0', (char)'3', (char)'0'));
        Assert.assertEquals((long)-1130L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'1', (char)'3', (char)'0'));
        Assert.assertEquals((long)-1111L, (long)DecoderUtils.decodeZone((char)'-', (char)'1', (char)'1', (char)'1', (char)'1'));
    }

    @Test
    public void testBogusZones() throws Exception {
        this.checkRejectZone(" 0000");
        this.checkRejectZone(" GMT ");
        this.checkRejectZone("DANG!");
        this.checkRejectZone("+a000");
        this.checkRejectZone("+0b00");
        this.checkRejectZone("+00c0");
        this.checkRejectZone("+000d");
        this.checkRejectZone("-a000");
        this.checkRejectZone("-0b00");
        this.checkRejectZone("-00c0");
        this.checkRejectZone("-000d");
    }

    private void checkRejectZone(String zone) {
        try {
            DecoderUtils.decodeZone((char)zone.charAt(0), (char)zone.charAt(1), (char)zone.charAt(2), (char)zone.charAt(3), (char)zone.charAt(4));
            Assert.fail((String)(zone + "is not a timezone"));
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }

    @Test
    public void testIsSimpleDigit() throws Exception {
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'0'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'1'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'2'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'3'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'4'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'5'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'6'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'7'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'8'));
        Assert.assertTrue((boolean)DecoderUtils.isSimpleDigit((char)'9'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'/'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'.'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'-'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'+'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)','));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'*'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)':'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)';'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'<'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'='));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'>'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'A'));
        Assert.assertFalse((boolean)DecoderUtils.isSimpleDigit((char)'B'));
    }

    @Test
    public void testDecodeNumber() throws Exception {
        Assert.assertEquals((long)1L, (long)DecoderUtils.decodeNumber((char)'0', (char)'1'));
        Assert.assertEquals((long)2L, (long)DecoderUtils.decodeNumber((char)'0', (char)'2'));
        Assert.assertEquals((long)3L, (long)DecoderUtils.decodeNumber((char)'0', (char)'3'));
        Assert.assertEquals((long)4L, (long)DecoderUtils.decodeNumber((char)'0', (char)'4'));
        Assert.assertEquals((long)5L, (long)DecoderUtils.decodeNumber((char)'0', (char)'5'));
        Assert.assertEquals((long)6L, (long)DecoderUtils.decodeNumber((char)'0', (char)'6'));
        Assert.assertEquals((long)7L, (long)DecoderUtils.decodeNumber((char)'0', (char)'7'));
        Assert.assertEquals((long)8L, (long)DecoderUtils.decodeNumber((char)'0', (char)'8'));
        Assert.assertEquals((long)9L, (long)DecoderUtils.decodeNumber((char)'0', (char)'9'));
        Assert.assertEquals((long)19L, (long)DecoderUtils.decodeNumber((char)'1', (char)'9'));
        Assert.assertEquals((long)28L, (long)DecoderUtils.decodeNumber((char)'2', (char)'8'));
        Assert.assertEquals((long)37L, (long)DecoderUtils.decodeNumber((char)'3', (char)'7'));
        Assert.assertEquals((long)46L, (long)DecoderUtils.decodeNumber((char)'4', (char)'6'));
        Assert.assertEquals((long)55L, (long)DecoderUtils.decodeNumber((char)'5', (char)'5'));
        Assert.assertEquals((long)64L, (long)DecoderUtils.decodeNumber((char)'6', (char)'4'));
        Assert.assertEquals((long)73L, (long)DecoderUtils.decodeNumber((char)'7', (char)'3'));
        Assert.assertEquals((long)82L, (long)DecoderUtils.decodeNumber((char)'8', (char)'2'));
        Assert.assertEquals((long)91L, (long)DecoderUtils.decodeNumber((char)'9', (char)'1'));
    }

    @Test
    public void testRejectNumber() throws Exception {
        this.checkRejectNumber("A1");
        this.checkRejectNumber("1A");
        this.checkRejectNumber("AA");
    }

    private void checkRejectNumber(String number) {
        try {
            DecoderUtils.decodeNumber((char)number.charAt(0), (char)number.charAt(1));
            Assert.fail((String)(number + "is not a number"));
        }
        catch (DecodingException decodingException) {
            // empty catch block
        }
    }
}

