/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import org.apache.james.imap.main.AbstractTestOutputStreamImapResponseWriter;
import org.junit.Test;

public class OutputStreamImapResponseWriterTest
extends AbstractTestOutputStreamImapResponseWriter {
    @Test
    public void testCloseParen() throws Exception {
        this.writer.closeParen();
        this.checkExpected(")");
    }

    @Test
    public void testOpenParen() throws Exception {
        this.writer.openParen();
        this.checkExpected(" (");
    }

    @Test
    public void testOpenParenMessageCloseParen() throws Exception {
        this.writer.openParen();
        this.writer.message("Hello");
        this.writer.closeParen();
        this.checkExpected(" (Hello)");
    }

    @Test
    public void testOpenParenQuoteCloseParen() throws Exception {
        this.writer.openParen();
        this.writer.quote("Hello");
        this.writer.closeParen();
        this.checkExpected(" (\"Hello\")");
    }

    @Test
    public void testOpenParenOpenParenMessageCloseParenCloseParen() throws Exception {
        this.writer.openParen();
        this.writer.openParen();
        this.writer.quote("Hello");
        this.writer.closeParen();
        this.writer.closeParen();
        this.checkExpected(" ((\"Hello\"))");
    }

    @Test
    public void testOpenParenCloseParenMessage() throws Exception {
        this.writer.openParen();
        this.writer.closeParen();
        this.writer.message("Hello");
        this.checkExpected(" () Hello");
    }
}

