/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import org.apache.james.imap.main.AbstractTestOutputStreamImapResponseWriter;
import org.junit.Test;

public class OutputStreamImapResponseWriterQuoteTest
extends AbstractTestOutputStreamImapResponseWriter {
    @Test
    public void testEmpty() throws Exception {
        this.writer.quote("");
        this.checkExpected(" \"\"");
    }

    @Test
    public void testStartSlash() throws Exception {
        this.writer.quote("\\");
        this.checkExpected(" \"\\\\\"");
    }

    @Test
    public void testSimpleQuote() throws Exception {
        this.writer.quote("Simple");
        this.checkExpected(" \"Simple\"");
    }

    @Test
    public void testComplexQuote() throws Exception {
        this.writer.quote("Complex Quote With Spaces");
        this.checkExpected(" \"Complex Quote With Spaces\"");
    }

    @Test
    public void testDQuoteQuote() throws Exception {
        this.writer.quote("Complex\"Quote With Spaces");
        this.checkExpected(" \"Complex\\\"Quote With Spaces\"");
    }

    @Test
    public void testFSlashQuote() throws Exception {
        this.writer.quote("Complex Quote \\With Spaces");
        this.checkExpected(" \"Complex Quote \\\\With Spaces\"");
    }
}

