/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.main.ImapRequestStreamHandler;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class ImapRequestHandlerAdandonConnectionTest {
    ImapRequestStreamHandler subject;
    ByteArrayOutputStream fakeOutput;
    ImapDecoder decoderStub;
    ImapProcessor processorStub;
    ImapEncoder encoderStub;
    ImapSession sessionStub;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.fakeOutput = new ByteArrayOutputStream();
        this.decoderStub = (ImapDecoder)this.mockery.mock(ImapDecoder.class);
        this.processorStub = (ImapProcessor)this.mockery.mock(ImapProcessor.class);
        this.encoderStub = (ImapEncoder)this.mockery.mock(ImapEncoder.class);
        this.sessionStub = (ImapSession)this.mockery.mock(ImapSession.class);
        this.subject = new ImapRequestStreamHandler(this.decoderStub, this.processorStub, this.encoderStub);
    }

    @Test
    public void testWhenConsumeLineFailsShouldAbandonConnection() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(ImapRequestHandlerAdandonConnectionTest.this.decoderStub);
                this.ignoring(ImapRequestHandlerAdandonConnectionTest.this.processorStub);
                this.ignoring(ImapRequestHandlerAdandonConnectionTest.this.encoderStub);
                this.ignoring(ImapRequestHandlerAdandonConnectionTest.this.sessionStub);
            }
        });
        byte[] endOfStreamAfterOneCharacter = new byte[]{48};
        ByteArrayInputStream fakeInput = new ByteArrayInputStream(endOfStreamAfterOneCharacter);
        boolean result = this.subject.handleRequest((InputStream)fakeInput, (OutputStream)this.fakeOutput, this.sessionStub);
        Assert.assertFalse((String)"Connection should be abandoned", (boolean)result);
    }
}

