/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.base.InternetPrintWriter;
import org.apache.james.imap.message.response.Literal;

public class ByteImapResponseWriter
implements ImapConstants,
ImapResponseWriter {
    private static final int LOWER_CASE_OFFSET = 32;
    private PrintWriter writer;
    private ByteArrayOutputStream out;
    private boolean skipNextSpace;

    public ByteImapResponseWriter() {
        this.clear();
    }

    public byte[] getBytes() throws Exception {
        this.writer.flush();
        this.out.flush();
        return this.out.toByteArray();
    }

    public void untaggedResponse(String message) {
        this.untagged();
        this.message(message);
        this.end();
    }

    public void byeResponse(String message) {
        this.untaggedResponse("BYE " + message);
    }

    public void untagged() {
        this.writer.print("*");
    }

    public void tag(String tag) {
        this.writer.print(tag);
    }

    public void message(String message) {
        if (message != null) {
            this.space();
            this.writer.print(message);
        }
    }

    public void message(long number) {
        this.space();
        this.writer.print(number);
    }

    public void responseCode(String responseCode) {
        if (responseCode != null) {
            this.writer.print(" [");
            this.writer.print(responseCode);
            this.writer.print("]");
        }
    }

    public void end() {
        this.writer.println();
        this.writer.flush();
    }

    public void commandName(String commandName) {
        this.space();
        this.writer.print(commandName);
    }

    public void quote(String message) {
        this.space();
        this.writer.print('\"');
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            char character = message.charAt(i);
            if (character == '\\' || character == '\"') {
                this.writer.print('\\');
            }
            this.writer.print(character);
        }
        this.writer.print('\"');
    }

    public void closeParen() {
        this.closeBracket(')');
    }

    private void closeBracket(char bracket) {
        this.writer.print(bracket);
        this.clearSkipNextSpace();
    }

    public void openParen() {
        this.openBracket('(');
    }

    private void openBracket(char bracket) {
        this.space();
        this.writer.print(bracket);
        this.skipNextSpace();
    }

    public void clear() {
        this.out = new ByteArrayOutputStream();
        this.writer = new InternetPrintWriter(this.out, true);
        this.skipNextSpace = false;
    }

    private void clearSkipNextSpace() {
        this.skipNextSpace = false;
    }

    public void skipNextSpace() {
        this.skipNextSpace = true;
    }

    public void space() {
        if (this.skipNextSpace) {
            this.skipNextSpace = false;
        } else {
            this.writer.print(' ');
        }
    }

    public void literal(Literal literal) throws IOException {
        this.space();
        this.writer.flush();
        WritableByteChannel channel = Channels.newChannel(this.out);
        literal.writeTo(channel);
        this.writer.flush();
    }

    public void closeSquareBracket() throws IOException {
        this.closeBracket(']');
    }

    public void openSquareBracket() throws IOException {
        this.openBracket('[');
    }

    public void upperCaseAscii(String message) throws IOException {
        this.upperCaseAscii(message, false);
    }

    private void upperCaseAscii(String message, boolean quote) {
        this.space();
        if (quote) {
            this.writer.print('\"');
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            char next = message.charAt(i);
            if (next >= 'a' && next <= 'z') {
                this.writer.print(next + 32);
                continue;
            }
            this.writer.print(next);
        }
        if (quote) {
            this.writer.print('\"');
        }
    }

    public void quoteUpperCaseAscii(String message) {
        this.upperCaseAscii(message, true);
    }
}

