/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.MockImapResponseWriter;
import org.apache.james.imap.encode.StatusResponseEncoder;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.apache.james.imap.encode.main.DefaultLocalizer;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class StatusResponseEncoderTest {
    private static final String COMMAND = "COMMAND";
    private static final String TAG = "TAG";
    private static final HumanReadableText KEY = new HumanReadableText("KEY", "TEXT");
    MockImapResponseWriter writer;
    ImapResponseComposer response;
    ImapEncoder mockNextEncoder;
    StatusResponse mockStatusResponse;
    StatusResponseEncoder encoder;
    ImapCommand stubCommand;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.writer = new MockImapResponseWriter();
        this.response = new ImapResponseComposerImpl((ImapResponseWriter)this.writer);
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.mockStatusResponse = (StatusResponse)this.context.mock(StatusResponse.class);
        this.encoder = new StatusResponseEncoder(this.mockNextEncoder, (Localizer)new DefaultLocalizer());
        this.stubCommand = ImapCommand.anyStateCommand((String)COMMAND);
    }

    @Test
    public void testTaggedOkCode() throws Exception {
        this.execute(StatusResponse.Type.OK, StatusResponse.ResponseCode.alert(), KEY, TAG);
        Assert.assertEquals((long)8L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("OK"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(6));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(7));
    }

    @Test
    public void testTaggedOkNoCode() throws Exception {
        this.execute(StatusResponse.Type.OK, null, KEY, TAG);
        Assert.assertEquals((long)5L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("OK"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(4));
    }

    @Test
    public void testTaggedBadCode() throws Exception {
        this.execute(StatusResponse.Type.BAD, StatusResponse.ResponseCode.alert(), KEY, TAG);
        Assert.assertEquals((long)8L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("BAD"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(6));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(7));
    }

    @Test
    public void testTaggedBadNoCode() throws Exception {
        this.execute(StatusResponse.Type.BAD, null, KEY, TAG);
        Assert.assertEquals((long)5L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("BAD"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(4));
    }

    @Test
    public void testTaggedNoCode() throws Exception {
        this.execute(StatusResponse.Type.NO, StatusResponse.ResponseCode.alert(), KEY, TAG);
        Assert.assertEquals((long)8L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("NO"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(6));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(7));
    }

    @Test
    public void testTaggedNoNoCode() throws Exception {
        this.execute(StatusResponse.Type.NO, null, KEY, TAG);
        Assert.assertEquals((long)5L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("NO"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.CommandNameOperation(COMMAND), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(4));
    }

    @Test
    public void testUntaggedOkCode() throws Exception {
        this.execute(StatusResponse.Type.OK, StatusResponse.ResponseCode.alert(), KEY, null);
        Assert.assertEquals((long)7L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("OK"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(6));
    }

    @Test
    public void testUntaggedOkNoCode() throws Exception {
        this.execute(StatusResponse.Type.OK, null, KEY, null);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("OK"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    @Test
    public void testUntaggedBadCode() throws Exception {
        this.execute(StatusResponse.Type.BAD, StatusResponse.ResponseCode.alert(), KEY, null);
        Assert.assertEquals((long)7L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("BAD"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(6));
    }

    @Test
    public void testUntaggedBadNoCode() throws Exception {
        this.execute(StatusResponse.Type.BAD, null, KEY, null);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("BAD"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    @Test
    public void testUntaggedNoCode() throws Exception {
        this.execute(StatusResponse.Type.NO, StatusResponse.ResponseCode.alert(), KEY, null);
        Assert.assertEquals((long)7L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("NO"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.openSquare(), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(StatusResponse.ResponseCode.alert().getCode()), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)MockImapResponseWriter.BracketOperation.closeSquare(), (Object)this.writer.operations.get(4));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(5));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(6));
    }

    @Test
    public void testUntaggedNoNoCode() throws Exception {
        this.execute(StatusResponse.Type.NO, null, KEY, null);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("NO"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(KEY.getDefaultValue()), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    private void execute(StatusResponse.Type type, StatusResponse.ResponseCode code, HumanReadableText key, String tag) throws Exception {
        this.configure(type, code, key, tag);
        this.compose();
    }

    private void compose() throws Exception {
        this.encoder.doEncode((ImapMessage)this.mockStatusResponse, this.response, (ImapSession)new FakeImapSession());
    }

    private void configure(final StatusResponse.Type type, final StatusResponse.ResponseCode code, final HumanReadableText key, final String tag) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getServerResponseType();
                this.will(1.returnValue((Object)type));
                ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getTag();
                this.will(1.returnValue((Object)tag));
                ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getTextKey();
                this.will(1.returnValue((Object)key));
                ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getResponseCode();
                this.will(1.returnValue((Object)code));
                if (tag == null) {
                    ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getCommand();
                    this.will(1.returnValue(null));
                } else {
                    ((StatusResponse)this.oneOf(StatusResponseEncoderTest.this.mockStatusResponse)).getCommand();
                    this.will(1.returnValue((Object)StatusResponseEncoderTest.this.stubCommand));
                }
            }
        });
    }
}

