/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.response.Literal;

public class MockImapResponseWriter
implements ImapResponseWriter {
    public final List<Object> operations = new ArrayList<Object>();

    public void commandName(String commandName) {
        this.operations.add(new CommandNameOperation(commandName));
    }

    public void end() {
        this.operations.add(new EndOperation());
    }

    public void message(String message) {
        this.operations.add(new TextMessageOperation(message));
    }

    public void message(long number) {
        this.operations.add(new NumericMessageOperation(number));
    }

    public void responseCode(String responseCode) {
        this.operations.add(new ResponseCodeOperation(responseCode));
    }

    public void tag(String tag) {
        this.operations.add(new TagOperation(tag));
    }

    public void untagged() {
        this.operations.add(new UntaggedOperation());
    }

    public void quote(String message) {
        this.operations.add(new QuoteMessageOperation(message));
    }

    public void closeParen() {
        this.operations.add(new BracketOperation(false, false));
    }

    public void openParen() {
        this.operations.add(new BracketOperation(true, false));
    }

    public void literal(Literal literal) throws IOException {
        this.operations.add(new LiteralOperation(literal));
    }

    public void skipNextSpace() throws IOException {
    }

    public void closeSquareBracket() throws IOException {
        this.operations.add(new BracketOperation(false, true));
    }

    public void openSquareBracket() throws IOException {
        this.operations.add(new BracketOperation(true, true));
    }

    public void upperCaseAscii(String message) throws IOException {
        this.operations.add(new UpperCaseASCIIOperation(message, false));
    }

    public void quoteUpperCaseAscii(String message) throws IOException {
        this.operations.add(new UpperCaseASCIIOperation(message, true));
    }

    public void space() {
    }

    public static final class UpperCaseASCIIOperation {
        public final String message;
        public final boolean quote;

        public UpperCaseASCIIOperation(String message, boolean quote) {
            this.message = message;
            this.quote = quote;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpperCaseASCIIOperation other = (UpperCaseASCIIOperation)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }
    }

    public static final class LiteralOperation {
        public final Literal literal;

        public LiteralOperation(Literal literal) {
            this.literal = literal;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LiteralOperation other = (LiteralOperation)obj;
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }
    }

    public static class BracketOperation {
        private final boolean open;
        private final boolean square;

        public static BracketOperation openSquare() {
            return new BracketOperation(true, true);
        }

        public static BracketOperation closeSquare() {
            return new BracketOperation(false, true);
        }

        public BracketOperation(boolean open, boolean square) {
            this.open = open;
            this.square = square;
        }

        public final boolean isOpen() {
            return this.open;
        }

        public final boolean isSquare() {
            return this.square;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.open ? 1231 : 1237);
            result = 31 * result + (this.square ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BracketOperation other = (BracketOperation)obj;
            if (this.open != other.open) {
                return false;
            }
            return this.square == other.square;
        }
    }

    public static class TagOperation {
        private final String tag;

        public TagOperation(String tag) {
            this.tag = tag;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagOperation other = (TagOperation)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }

    public static class UntaggedOperation {
        public boolean equals(Object obj) {
            return obj instanceof UntaggedOperation;
        }

        public int hashCode() {
            return 2;
        }
    }

    public static class CommandNameOperation {
        public final String commandName;

        public CommandNameOperation(String commandName) {
            this.commandName = commandName;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.commandName == null ? 0 : this.commandName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandNameOperation other = (CommandNameOperation)obj;
            return !(this.commandName == null ? other.commandName != null : !this.commandName.equals(other.commandName));
        }
    }

    public static class ResponseCodeOperation {
        public final String responseCode;

        public ResponseCodeOperation(String responseCode) {
            this.responseCode = responseCode;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.responseCode == null ? 0 : this.responseCode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseCodeOperation other = (ResponseCodeOperation)obj;
            return !(this.responseCode == null ? other.responseCode != null : !this.responseCode.equals(other.responseCode));
        }
    }

    public static class NumericMessageOperation {
        public final long number;

        public NumericMessageOperation(long number) {
            this.number = number;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = (int)((long)(31 * result) + this.number);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NumericMessageOperation other = (NumericMessageOperation)obj;
            return this.number == other.number;
        }
    }

    public static class TextMessageOperation {
        public final String text;

        public TextMessageOperation(String text) {
            this.text = text;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextMessageOperation other = (TextMessageOperation)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }

    public static class QuoteMessageOperation {
        public final String message;

        public QuoteMessageOperation(String message) {
            this.message = message;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QuoteMessageOperation other = (QuoteMessageOperation)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }
    }

    public static class EndOperation {
        public boolean equals(Object obj) {
            return obj instanceof EndOperation;
        }

        public int hashCode() {
            return 3;
        }
    }
}

