/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.MailboxStatusResponseEncoder;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class MailboxStatusResponseEncoderTest {
    MailboxStatusResponseEncoder encoder;
    ImapEncoder mockNextEncoder;
    ImapResponseComposer composer;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.encoder = new MailboxStatusResponseEncoder(this.mockNextEncoder);
    }

    @Test
    public void testIsAcceptable() throws Exception {
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)new MailboxStatusResponse(null, null, null, null, null, "mailbox")));
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
        Assert.assertFalse((boolean)this.encoder.isAcceptable(null));
    }

    @Test
    public void testDoEncode() throws Exception {
        final Long messages = new Long(2L);
        final Long recent = new Long(3L);
        final Long uidNext = new Long(5L);
        final Long uidValidity = new Long(7L);
        final Long unseen = new Long(11L);
        String mailbox = "A mailbox named desire";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(MailboxStatusResponseEncoderTest.this.composer)).statusResponse(Long.valueOf(this.with(1.same((Object)messages))), Long.valueOf(this.with(1.same((Object)recent))), Long.valueOf(this.with(1.same((Object)uidNext))), Long.valueOf(this.with(1.same((Object)uidValidity))), Long.valueOf(this.with(1.same((Object)unseen))), (String)this.with(1.same((Object)"A mailbox named desire")));
            }
        });
        this.encoder.encode((ImapMessage)new MailboxStatusResponse(messages, recent, uidNext, uidValidity, unseen, "A mailbox named desire"), this.composer, (ImapSession)new FakeImapSession());
    }
}

