/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ListingEncodingUtils;
import org.apache.james.imap.message.response.AbstractListingResponse;
import org.apache.james.imap.message.response.ListResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class ListingEncodingUtilsTest {
    final String nameParameter = "LIST";
    final String typeNameParameters = "A Type Name";
    List<String> attributesOutput;
    ImapResponseComposer mock;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mock = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.attributesOutput = new ArrayList<String>();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(ListingEncodingUtilsTest.this.mock)).listResponse((String)this.with(1.equal((Object)"A Type Name")), (List)this.with(1.equal(ListingEncodingUtilsTest.this.attributesOutput)), (String)this.with(1.equal((Object)".")), (String)this.with(1.equal((Object)"LIST")));
            }
        });
    }

    @Test
    public void testShouldAddHasChildrenToAttributes() throws Exception {
        this.attributesOutput.add("\\HasChildren");
        ListResponse input = new ListResponse(false, false, false, false, true, false, "LIST");
        ListingEncodingUtils.encodeListingResponse((String)"A Type Name", (ImapResponseComposer)this.mock, (AbstractListingResponse)input);
    }

    @Test
    public void testShouldAddHasNoChildrenToAttributes() throws Exception {
        this.attributesOutput.add("\\HasNoChildren");
        ListResponse input = new ListResponse(false, false, false, false, false, true, "LIST");
        ListingEncodingUtils.encodeListingResponse((String)"A Type Name", (ImapResponseComposer)this.mock, (AbstractListingResponse)input);
    }
}

