/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.LSubResponseEncoder;
import org.apache.james.imap.message.response.LSubResponse;
import org.apache.james.imap.message.response.ListResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class LSubResponseEncoderTest {
    LSubResponseEncoder encoder;
    ImapEncoder mockNextEncoder;
    ImapResponseComposer composer;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.encoder = new LSubResponseEncoder(this.mockNextEncoder);
    }

    @Test
    public void testIsAcceptable() {
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)new ListResponse(true, true, true, true, false, false, "name")));
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)new LSubResponse("name", true)));
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
        Assert.assertFalse((boolean)this.encoder.isAcceptable(null));
    }

    @Test
    public void testName() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(LSubResponseEncoderTest.this.composer)).listResponse((String)this.with(1.equal((Object)"LSUB")), (List)this.with(1.aNull(List.class)), (String)this.with(1.equal((Object)".")), (String)this.with(1.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new LSubResponse("INBOX.name", false), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testDelimiter() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(LSubResponseEncoderTest.this.composer)).listResponse((String)this.with(2.equal((Object)"LSUB")), (List)this.with(2.aNull(List.class)), (String)this.with(2.equal((Object)".")), (String)this.with(2.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new LSubResponse("INBOX.name", false), this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testNoSelect() throws Exception {
        final String[] values = new String[]{"\\Noselect"};
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapResponseComposer)this.oneOf(LSubResponseEncoderTest.this.composer)).listResponse((String)this.with(3.equal((Object)"LSUB")), (List)this.with(3.equal(Arrays.asList(values))), (String)this.with(3.equal((Object)".")), (String)this.with(3.equal((Object)"INBOX.name")));
            }
        });
        this.encoder.encode((ImapMessage)new LSubResponse("INBOX.name", true), this.composer, (ImapSession)new FakeImapSession());
    }
}

