/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import javax.mail.Flags;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.encode.MockImapResponseWriter;
import org.apache.james.imap.encode.base.ImapResponseComposerImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImapResponseTest {
    private static final String TAG = "TAG";
    ImapResponseComposer response;
    MockImapResponseWriter writer;

    @Before
    public void setUp() throws Exception {
        this.writer = new MockImapResponseWriter();
        this.response = new ImapResponseComposerImpl((ImapResponseWriter)this.writer);
    }

    @Test
    public void testFlagsResponse() throws Exception {
        Flags flags = new Flags();
        this.response.flagsResponse(flags);
        Assert.assertEquals((long)5L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("FLAGS"), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.BracketOperation(true, false), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.BracketOperation(false, false), (Object)this.writer.operations.get(3));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(4));
    }

    @Test
    public void testExistsResponse() throws Exception {
        int count = 5;
        this.response.existsResponse((long)count);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.NumericMessageOperation(count), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("EXISTS"), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    @Test
    public void testRecentResponse() throws Exception {
        int count = 5;
        this.response.recentResponse((long)count);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.NumericMessageOperation(count), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("RECENT"), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    @Test
    public void testExpungeResponse() throws Exception {
        int count = 5;
        this.response.expungeResponse((long)count);
        Assert.assertEquals((long)4L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.NumericMessageOperation(count), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("EXPUNGE"), (Object)this.writer.operations.get(2));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(3));
    }

    @Test
    public void testTaggedResponse() throws Exception {
        String message = "A message";
        this.response.taggedResponse(message, TAG);
        Assert.assertEquals((long)3L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.TagOperation(TAG), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(message), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(2));
    }

    @Test
    public void testUntaggedResponse() throws Exception {
        String message = "A message";
        this.response.untaggedResponse(message);
        Assert.assertEquals((long)3L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation(message), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(2));
    }

    @Test
    public void testByeResponse() throws Exception {
        String message = "A message";
        this.response.byeResponse(message);
        Assert.assertEquals((long)3L, (long)this.writer.operations.size());
        Assert.assertEquals((Object)new MockImapResponseWriter.UntaggedOperation(), (Object)this.writer.operations.get(0));
        Assert.assertEquals((Object)new MockImapResponseWriter.TextMessageOperation("BYE " + message), (Object)this.writer.operations.get(1));
        Assert.assertEquals((Object)new MockImapResponseWriter.EndOperation(), (Object)this.writer.operations.get(2));
    }
}

