/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.FetchResponseEncoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.FetchResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class FetchResponseEncoderTest {
    Flags flags;
    ImapResponseComposer composer;
    ImapEncoder mockNextEncoder;
    FetchResponseEncoder encoder;
    ImapCommand stubCommand;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.encoder = new FetchResponseEncoder(this.mockNextEncoder, false);
        this.stubCommand = ImapCommand.anyStateCommand((String)"COMMAND");
        this.flags = new Flags(Flags.Flag.DELETED);
    }

    @Test
    public void testShouldNotAcceptUnknownResponse() throws Exception {
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
    }

    @Test
    public void testShouldAcceptFetchResponse() throws Exception {
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)new FetchResponse(11, null, null, null, null, null, null, null, null)));
    }

    @Test
    public void testShouldEncodeFlagsResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, this.flags, null, null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).openFetchResponse(this.with(1.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).flags((Flags)this.with(1.equal((Object)FetchResponseEncoderTest.this.flags)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldEncodeUidResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, null, new Long(72L), null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).openFetchResponse(this.with(2.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).message((String)this.with(2.equal((Object)"UID")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).message(this.with(2.equal((Object)72L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldEncodeAllResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, this.flags, new Long(72L), null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).openFetchResponse(this.with(3.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).flags((Flags)this.with(3.equal((Object)FetchResponseEncoderTest.this.flags)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).message((String)this.with(3.equal((Object)"UID")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).message(this.with(3.equal((Object)72L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }
}

