/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.util.ArrayList;
import java.util.HashMap;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.FakeImapSession;
import org.apache.james.imap.encode.FetchResponseEncoder;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.message.response.FetchResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class FetchResponseEncoderNoExtensionsTest {
    Flags flags;
    ImapResponseComposer composer;
    FetchResponse.Structure stubStructure;
    ImapEncoder mockNextEncoder;
    FetchResponseEncoder encoder;
    ImapCommand stubCommand;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.composer = (ImapResponseComposer)this.context.mock(ImapResponseComposer.class);
        this.mockNextEncoder = (ImapEncoder)this.context.mock(ImapEncoder.class);
        this.encoder = new FetchResponseEncoder(this.mockNextEncoder, true);
        this.stubCommand = ImapCommand.anyStateCommand((String)"COMMAND");
        this.flags = new Flags(Flags.Flag.DELETED);
        this.stubStructure = (FetchResponse.Structure)this.context.mock(FetchResponse.Structure.class);
    }

    @Test
    public void testShouldNotAcceptUnknownResponse() throws Exception {
        Assert.assertFalse((boolean)this.encoder.isAcceptable((ImapMessage)this.context.mock(ImapMessage.class)));
    }

    @Test
    public void testShouldAcceptFetchResponse() throws Exception {
        Assert.assertTrue((boolean)this.encoder.isAcceptable((ImapMessage)new FetchResponse(11, null, null, null, null, null, null, null, null)));
    }

    @Test
    public void testShouldEncodeFlagsResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, this.flags, null, null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderNoExtensionsTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).openFetchResponse(this.with(1.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).flags((Flags)this.with(1.equal((Object)FetchResponseEncoderNoExtensionsTest.this.flags)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldEncodeUidResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, null, new Long(72L), null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderNoExtensionsTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).openFetchResponse(this.with(2.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message((String)this.with(2.equal((Object)"UID")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message(this.with(2.equal((Object)72L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldEncodeAllResponse() throws Exception {
        FetchResponse message = new FetchResponse(100, this.flags, new Long(72L), null, null, null, null, null, null);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                Sequence sequence = FetchResponseEncoderNoExtensionsTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).openFetchResponse(this.with(3.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).flags((Flags)this.with(3.equal((Object)FetchResponseEncoderNoExtensionsTest.this.flags)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message((String)this.with(3.equal((Object)"UID")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message(this.with(3.equal((Object)72L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)new FakeImapSession());
    }

    @Test
    public void testShouldNotAddExtensionsWithEncodingBodyStructure() throws Exception {
        FetchResponse message = new FetchResponse(100, this.flags, new Long(72L), null, null, null, null, this.stubStructure, null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("CHARSET", "US-ASCII");
        final ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add("CHARSET");
        parameterList.add("US-ASCII");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                long octets = 2279L;
                long lines = 48L;
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getMediaType();
                this.will(4.returnValue((Object)"TEXT"));
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getSubType();
                this.will(4.returnValue((Object)"HTML"));
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getOctets();
                this.will(4.returnValue((Object)2279L));
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getLines();
                this.will(4.returnValue((Object)48L));
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getParameters();
                this.will(4.returnValue((Object)parameterList));
                ((FetchResponse.Structure)this.allowing(FetchResponseEncoderNoExtensionsTest.this.stubStructure)).getEncoding();
                this.will(4.returnValue((Object)"7BIT"));
                this.ignoring(FetchResponseEncoderNoExtensionsTest.this.stubStructure);
                Sequence sequence = FetchResponseEncoderNoExtensionsTest.this.context.sequence("composition");
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).openFetchResponse(this.with(4.equal((Object)100L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).flags((Flags)this.with(4.equal((Object)FetchResponseEncoderNoExtensionsTest.this.flags)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message((String)this.with(4.equal((Object)"BODYSTRUCTURE")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).openParen();
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).quoteUpperCaseAscii("TEXT");
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).quoteUpperCaseAscii("HTML");
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).nillableQuotes(parameterList);
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).nillableQuote("");
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).nillableQuote("");
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).quoteUpperCaseAscii("7BIT");
                this.will(4.returnValue((Object)FetchResponseEncoderNoExtensionsTest.this.composer));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message(2279L);
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message(48L);
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).closeParen();
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message((String)this.with(4.equal((Object)"UID")));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).message(this.with(4.equal((Object)72L)));
                this.inSequence(sequence);
                ((ImapResponseComposer)this.oneOf(FetchResponseEncoderNoExtensionsTest.this.composer)).closeFetchResponse();
                this.inSequence(sequence);
            }
        });
        FakeImapSession fakeImapSession = new FakeImapSession();
        this.encoder.doEncode((ImapMessage)message, this.composer, (ImapSession)fakeImapSession);
    }
}

