/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.Flags;
import org.apache.commons.logging.Log;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.MockLogger;
import org.apache.james.imap.decode.parser.StoreCommandParser;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class StoreCommandParserTest {
    StoreCommandParser parser;
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.parser = new StoreCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.mockery.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.mockery.mock(ImapMessage.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
    }

    @Test
    public void testShouldParseSilentDraftFlagged() throws Exception {
        IdRange[] ranges = new IdRange[]{new IdRange(1L)};
        Flags flags = new Flags();
        flags.add(Flags.Flag.DRAFT);
        flags.add(Flags.Flag.FLAGGED);
        this.check("1 FLAGS.SILENT (\\Draft \\Flagged)\r\n", ranges, true, null, flags, false, "A01");
    }

    private void check(String input, final IdRange[] idSet, final boolean silent, final Boolean sign, final Flags flags, final boolean useUids, final String tag) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapMessageFactory)this.oneOf(StoreCommandParserTest.this.mockMessageFactory)).createStoreMessage((ImapCommand)this.with(1.equal((Object)StoreCommandParserTest.this.command)), (IdRange[])this.with(1.equal((Object)idSet)), this.with(1.equal((Object)silent)), Boolean.valueOf(this.with(1.equal((Object)sign))), (Flags)this.with(1.equal((Object)flags)), this.with(1.equal((Object)useUids)), (String)this.with(1.same((Object)tag)));
                this.will(1.returnValue((Object)StoreCommandParserTest.this.message));
            }
        });
        this.parser.decode(this.command, (ImapRequestLineReader)reader, tag, useUids, (Log)new MockLogger());
    }
}

