/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserSearchKeyTest {
    private static final DayMonthYear DATE = new DayMonthYear(1, 1, 2000);
    SearchCommandParser parser;
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.mockery.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.mockery.mock(ImapMessage.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
    }

    @Test
    public void testShouldParseAll() throws Exception {
        SearchKey key = SearchKey.buildAll();
        this.checkValid("ALL\r\n", key);
        this.checkValid("all\r\n", key);
        this.checkValid("alL\r\n", key);
        this.checkInvalid("al\r\n", key);
        this.checkInvalid("alm\r\n", key);
        this.checkInvalid("alm\r\n", key);
    }

    @Test
    public void testShouldParseAnswered() throws Exception {
        SearchKey key = SearchKey.buildAnswered();
        this.checkValid("ANSWERED\r\n", key);
        this.checkValid("answered\r\n", key);
        this.checkValid("aNSWEred\r\n", key);
        this.checkInvalid("a\r\n", key);
        this.checkInvalid("an\r\n", key);
        this.checkInvalid("ans\r\n", key);
        this.checkInvalid("answ\r\n", key);
        this.checkInvalid("answe\r\n", key);
        this.checkInvalid("answer\r\n", key);
        this.checkInvalid("answere\r\n", key);
    }

    @Test
    public void testShouldParseBcc() throws Exception {
        SearchKey key = SearchKey.buildBcc((String)"Somebody");
        this.checkValid("BCC Somebody\r\n", key);
        this.checkValid("BCC \"Somebody\"\r\n", key);
        this.checkValid("bcc Somebody\r\n", key);
        this.checkValid("bcc \"Somebody\"\r\n", key);
        this.checkValid("Bcc Somebody\r\n", key);
        this.checkValid("Bcc \"Somebody\"\r\n", key);
        this.checkInvalid("b\r\n", key);
        this.checkInvalid("bc\r\n", key);
        this.checkInvalid("bg\r\n", key);
        this.checkInvalid("bccc\r\n", key);
    }

    @Test
    public void testShouldParseOn() throws Exception {
        SearchKey key = SearchKey.buildOn((DayMonthYear)DATE);
        this.checkValid("ON 1-Jan-2000\r\n", key);
        this.checkValid("on 1-Jan-2000\r\n", key);
        this.checkValid("oN 1-Jan-2000\r\n", key);
        this.checkInvalid("o\r\n", key);
        this.checkInvalid("om\r\n", key);
        this.checkInvalid("oni\r\n", key);
        this.checkInvalid("on \r\n", key);
        this.checkInvalid("on 1\r\n", key);
        this.checkInvalid("on 1-\r\n", key);
        this.checkInvalid("on 1-J\r\n", key);
        this.checkInvalid("on 1-Ja\r\n", key);
        this.checkInvalid("on 1-Jan\r\n", key);
        this.checkInvalid("on 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseSentBefore() throws Exception {
        SearchKey key = SearchKey.buildSentBefore((DayMonthYear)DATE);
        this.checkValid("SENTBEFORE 1-Jan-2000\r\n", key);
        this.checkValid("sentbefore 1-Jan-2000\r\n", key);
        this.checkValid("SentBefore 1-Jan-2000\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("se\r\n", key);
        this.checkInvalid("sent\r\n", key);
        this.checkInvalid("sentb \r\n", key);
        this.checkInvalid("sentbe \r\n", key);
        this.checkInvalid("sentbef \r\n", key);
        this.checkInvalid("sentbefo \r\n", key);
        this.checkInvalid("sentbefor \r\n", key);
        this.checkInvalid("sentbefore \r\n", key);
        this.checkInvalid("sentbefore 1\r\n", key);
        this.checkInvalid("sentbefore 1-\r\n", key);
        this.checkInvalid("sentbefore 1-J\r\n", key);
        this.checkInvalid("sentbefore 1-Ja\r\n", key);
        this.checkInvalid("sentbefore 1-Jan\r\n", key);
        this.checkInvalid("sentbefore 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseSentOn() throws Exception {
        SearchKey key = SearchKey.buildSentOn((DayMonthYear)DATE);
        this.checkValid("SENTON 1-Jan-2000\r\n", key);
        this.checkValid("senton 1-Jan-2000\r\n", key);
        this.checkValid("SentOn 1-Jan-2000\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("se\r\n", key);
        this.checkInvalid("sent\r\n", key);
        this.checkInvalid("sento \r\n", key);
        this.checkInvalid("senton \r\n", key);
        this.checkInvalid("senton 1\r\n", key);
        this.checkInvalid("senton 1-\r\n", key);
        this.checkInvalid("senton 1-J\r\n", key);
        this.checkInvalid("senton 1-Ja\r\n", key);
        this.checkInvalid("senton 1-Jan\r\n", key);
        this.checkInvalid("senton 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseSentSince() throws Exception {
        SearchKey key = SearchKey.buildSentSince((DayMonthYear)DATE);
        this.checkValid("SENTSINCE 1-Jan-2000\r\n", key);
        this.checkValid("sentsince 1-Jan-2000\r\n", key);
        this.checkValid("SentSince 1-Jan-2000\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("se\r\n", key);
        this.checkInvalid("sent\r\n", key);
        this.checkInvalid("sents \r\n", key);
        this.checkInvalid("sentsi \r\n", key);
        this.checkInvalid("sentsin \r\n", key);
        this.checkInvalid("sentsinc \r\n", key);
        this.checkInvalid("sentsince \r\n", key);
        this.checkInvalid("sentsince 1\r\n", key);
        this.checkInvalid("sentsince 1-\r\n", key);
        this.checkInvalid("sentsince 1-J\r\n", key);
        this.checkInvalid("sentsince 1-Ja\r\n", key);
        this.checkInvalid("sentsince 1-Jan\r\n", key);
        this.checkInvalid("sentsince 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseSince() throws Exception {
        SearchKey key = SearchKey.buildSince((DayMonthYear)DATE);
        this.checkValid("SINCE 1-Jan-2000\r\n", key);
        this.checkValid("since 1-Jan-2000\r\n", key);
        this.checkValid("Since 1-Jan-2000\r\n", key);
        this.checkInvalid("s \r\n", key);
        this.checkInvalid("si \r\n", key);
        this.checkInvalid("sin \r\n", key);
        this.checkInvalid("sinc \r\n", key);
        this.checkInvalid("since \r\n", key);
        this.checkInvalid("since 1\r\n", key);
        this.checkInvalid("since 1-\r\n", key);
        this.checkInvalid("since 1-J\r\n", key);
        this.checkInvalid("since 1-Ja\r\n", key);
        this.checkInvalid("since 1-Jan\r\n", key);
        this.checkInvalid("since 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseBefore() throws Exception {
        SearchKey key = SearchKey.buildBefore((DayMonthYear)DATE);
        this.checkValid("BEFORE 1-Jan-2000\r\n", key);
        this.checkValid("before 1-Jan-2000\r\n", key);
        this.checkValid("BEforE 1-Jan-2000\r\n", key);
        this.checkInvalid("b\r\n", key);
        this.checkInvalid("B\r\n", key);
        this.checkInvalid("BE\r\n", key);
        this.checkInvalid("BEf\r\n", key);
        this.checkInvalid("BEfo\r\n", key);
        this.checkInvalid("BEfor\r\n", key);
        this.checkInvalid("BEforE\r\n", key);
        this.checkInvalid("BEforEi\r\n", key);
        this.checkInvalid("BEforE \r\n", key);
        this.checkInvalid("BEforE 1\r\n", key);
        this.checkInvalid("BEforE 1-\r\n", key);
        this.checkInvalid("BEforE 1-J\r\n", key);
        this.checkInvalid("BEforE 1-Ja\r\n", key);
        this.checkInvalid("BEforE 1-Jan\r\n", key);
        this.checkInvalid("BEforE 1-Jan-\r\n", key);
    }

    @Test
    public void testShouldParseBody() throws Exception {
        SearchKey key = SearchKey.buildBody((String)"Text");
        this.checkValid("BODY Text\r\n", key);
        this.checkValid("BODY \"Text\"\r\n", key);
        this.checkValid("body Text\r\n", key);
        this.checkValid("body \"Text\"\r\n", key);
        this.checkValid("BodY Text\r\n", key);
        this.checkValid("BodY \"Text\"\r\n", key);
        this.checkInvalid("b\r\n", key);
        this.checkInvalid("Bo\r\n", key);
        this.checkInvalid("Bod\r\n", key);
        this.checkInvalid("Bodd\r\n", key);
        this.checkInvalid("Bodym\r\n", key);
    }

    @Test
    public void testShouldParseTo() throws Exception {
        SearchKey key = SearchKey.buildTo((String)"AnAddress");
        this.checkValid("TO AnAddress\r\n", key);
        this.checkValid("TO \"AnAddress\"\r\n", key);
        this.checkValid("to AnAddress\r\n", key);
        this.checkValid("to \"AnAddress\"\r\n", key);
        this.checkValid("To AnAddress\r\n", key);
        this.checkValid("To \"AnAddress\"\r\n", key);
        this.checkInvalid("t\r\n", key);
        this.checkInvalid("to\r\n", key);
        this.checkInvalid("too\r\n", key);
        this.checkInvalid("to \r\n", key);
    }

    @Test
    public void testShouldParseText() throws Exception {
        SearchKey key = SearchKey.buildText((String)"SomeText");
        this.checkValid("TEXT SomeText\r\n", key);
        this.checkValid("TEXT \"SomeText\"\r\n", key);
        this.checkValid("text SomeText\r\n", key);
        this.checkValid("text \"SomeText\"\r\n", key);
        this.checkValid("Text SomeText\r\n", key);
        this.checkValid("Text \"SomeText\"\r\n", key);
        this.checkInvalid("t\r\n", key);
        this.checkInvalid("te\r\n", key);
        this.checkInvalid("tex\r\n", key);
        this.checkInvalid("text\r\n", key);
        this.checkInvalid("text \r\n", key);
    }

    @Test
    public void testShouldParseSubject() throws Exception {
        SearchKey key = SearchKey.buildSubject((String)"ASubject");
        this.checkValid("SUBJECT ASubject\r\n", key);
        this.checkValid("SUBJECT \"ASubject\"\r\n", key);
        this.checkValid("subject ASubject\r\n", key);
        this.checkValid("subject \"ASubject\"\r\n", key);
        this.checkValid("Subject ASubject\r\n", key);
        this.checkValid("Subject \"ASubject\"\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("su\r\n", key);
        this.checkInvalid("sub\r\n", key);
        this.checkInvalid("subj\r\n", key);
        this.checkInvalid("subje\r\n", key);
        this.checkInvalid("subjec\r\n", key);
        this.checkInvalid("subject\r\n", key);
        this.checkInvalid("subject \r\n", key);
    }

    @Test
    public void testShouldParseCc() throws Exception {
        SearchKey key = SearchKey.buildCc((String)"SomeText");
        this.checkValid("CC SomeText\r\n", key);
        this.checkValid("CC \"SomeText\"\r\n", key);
        this.checkValid("cc SomeText\r\n", key);
        this.checkValid("cc \"SomeText\"\r\n", key);
        this.checkValid("Cc SomeText\r\n", key);
        this.checkValid("Cc \"SomeText\"\r\n", key);
        this.checkInvalid("c\r\n", key);
        this.checkInvalid("cd\r\n", key);
        this.checkInvalid("ccc\r\n", key);
    }

    @Test
    public void testShouldParseFrom() throws Exception {
        SearchKey key = SearchKey.buildFrom((String)"Someone");
        this.checkValid("FROM Someone\r\n", key);
        this.checkValid("FROM \"Someone\"\r\n", key);
        this.checkValid("from Someone\r\n", key);
        this.checkValid("from \"Someone\"\r\n", key);
        this.checkValid("FRom Someone\r\n", key);
        this.checkValid("FRom \"Someone\"\r\n", key);
        this.checkInvalid("f\r\n", key);
        this.checkInvalid("fr\r\n", key);
        this.checkInvalid("ftom\r\n", key);
        this.checkInvalid("froml\r\n", key);
    }

    @Test
    public void testShouldParseKeyword() throws Exception {
        SearchKey key = SearchKey.buildKeyword((String)"AFlag");
        this.checkValid("KEYWORD AFlag\r\n", key);
        this.checkInvalid("KEYWORD \"AFlag\"\r\n", key);
        this.checkValid("keyword AFlag\r\n", key);
        this.checkInvalid("keyword \"AFlag\"\r\n", key);
        this.checkValid("KEYword AFlag\r\n", key);
        this.checkInvalid("KEYword \"AFlag\"\r\n", key);
        this.checkInvalid("k\r\n", key);
        this.checkInvalid("ke\r\n", key);
        this.checkInvalid("key\r\n", key);
        this.checkInvalid("keyw\r\n", key);
        this.checkInvalid("keywo\r\n", key);
        this.checkInvalid("keywor\r\n", key);
        this.checkInvalid("keywordi\r\n", key);
        this.checkInvalid("keyword \r\n", key);
    }

    @Test
    public void testShouldParseUnKeyword() throws Exception {
        SearchKey key = SearchKey.buildUnkeyword((String)"AFlag");
        this.checkValid("UNKEYWORD AFlag\r\n", key);
        this.checkInvalid("UNKEYWORD \"AFlag\"\r\n", key);
        this.checkValid("unkeyword AFlag\r\n", key);
        this.checkInvalid("unkeyword \"AFlag\"\r\n", key);
        this.checkValid("UnKEYword AFlag\r\n", key);
        this.checkInvalid("UnKEYword \"AFlag\"\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("unk\r\n", key);
        this.checkInvalid("unke\r\n", key);
        this.checkInvalid("unkey\r\n", key);
        this.checkInvalid("unkeyw\r\n", key);
        this.checkInvalid("unkeywo\r\n", key);
        this.checkInvalid("unkeywor\r\n", key);
        this.checkInvalid("unkeywordi\r\n", key);
        this.checkInvalid("unkeyword \r\n", key);
    }

    @Test
    public void testShouldParseHeader() throws Exception {
        SearchKey key = SearchKey.buildHeader((String)"Field", (String)"Value");
        this.checkValid("HEADER Field Value\r\n", key);
        this.checkValid("HEADER \"Field\" \"Value\"\r\n", key);
        this.checkValid("header Field Value\r\n", key);
        this.checkValid("header \"Field\" \"Value\"\r\n", key);
        this.checkValid("HEAder Field Value\r\n", key);
        this.checkValid("HEAder \"Field\" \"Value\"\r\n", key);
        this.checkInvalid("h\r\n", key);
        this.checkInvalid("he\r\n", key);
        this.checkInvalid("hea\r\n", key);
        this.checkInvalid("head\r\n", key);
        this.checkInvalid("heade\r\n", key);
        this.checkInvalid("header\r\n", key);
        this.checkInvalid("header field\r\n", key);
        this.checkInvalid("header field \r\n", key);
    }

    private void checkValid(String input, SearchKey key) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        Assert.assertEquals((Object)key, (Object)this.parser.searchKey((ImapRequestLineReader)reader, null, false));
    }

    @Test
    public void testShouldParseDeleted() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkValid("DELETED\r\n", key);
        this.checkValid("deleted\r\n", key);
        this.checkValid("deLEteD\r\n", key);
        this.checkInvalid("d\r\n", key);
        this.checkInvalid("de\r\n", key);
        this.checkInvalid("del\r\n", key);
        this.checkInvalid("dele\r\n", key);
        this.checkInvalid("delet\r\n", key);
        this.checkInvalid("delete\r\n", key);
    }

    @Test
    public void testEShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("e\r\n", key);
        this.checkInvalid("ee\r\n", key);
    }

    @Test
    public void testGShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("g\r\n", key);
        this.checkInvalid("G\r\n", key);
    }

    @Test
    public void testIShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("i\r\n", key);
        this.checkInvalid("I\r\n", key);
    }

    @Test
    public void testJShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("j\r\n", key);
        this.checkInvalid("J\r\n", key);
    }

    @Test
    public void testMShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("m\r\n", key);
        this.checkInvalid("M\r\n", key);
    }

    @Test
    public void testPShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("p\r\n", key);
        this.checkInvalid("Pp\r\n", key);
    }

    @Test
    public void testQShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("q\r\n", key);
        this.checkInvalid("Qq\r\n", key);
    }

    @Test
    public void testWShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("w\r\n", key);
        this.checkInvalid("ww\r\n", key);
    }

    @Test
    public void testVShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("v\r\n", key);
        this.checkInvalid("vv\r\n", key);
    }

    @Test
    public void testXShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("x\r\n", key);
        this.checkInvalid("xx\r\n", key);
    }

    @Test
    public void testYShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("y\r\n", key);
        this.checkInvalid("yy\r\n", key);
    }

    @Test
    public void testZShouldBeInvalid() throws Exception {
        SearchKey key = SearchKey.buildDeleted();
        this.checkInvalid("z\r\n", key);
        this.checkInvalid("zz\r\n", key);
    }

    @Test
    public void testShouldParseRecent() throws Exception {
        SearchKey key = SearchKey.buildRecent();
        this.checkValid("RECENT\r\n", key);
        this.checkValid("recent\r\n", key);
        this.checkValid("reCENt\r\n", key);
        this.checkInvalid("r\r\n", key);
        this.checkInvalid("re\r\n", key);
        this.checkInvalid("rec\r\n", key);
        this.checkInvalid("rece\r\n", key);
        this.checkInvalid("recen\r\n", key);
    }

    @Test
    public void testShouldParseDraft() throws Exception {
        SearchKey key = SearchKey.buildDraft();
        this.checkValid("DRAFT\r\n", key);
        this.checkValid("draft\r\n", key);
        this.checkValid("DRaft\r\n", key);
        this.checkInvalid("D\r\n", key);
        this.checkInvalid("DR\r\n", key);
        this.checkInvalid("DRA\r\n", key);
        this.checkInvalid("DRAF\r\n", key);
    }

    @Test
    public void testShouldParseUnanswered() throws Exception {
        SearchKey key = SearchKey.buildUnanswered();
        this.checkValid("UNANSWERED\r\n", key);
        this.checkValid("unanswered\r\n", key);
        this.checkValid("UnAnswered\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("una\r\n", key);
        this.checkInvalid("unan\r\n", key);
        this.checkInvalid("unans\r\n", key);
        this.checkInvalid("unansw\r\n", key);
        this.checkInvalid("unanswe\r\n", key);
        this.checkInvalid("unanswer\r\n", key);
        this.checkInvalid("unanswere\r\n", key);
    }

    @Test
    public void testShouldParseUndeleted() throws Exception {
        SearchKey key = SearchKey.buildUndeleted();
        this.checkValid("UNDELETED\r\n", key);
        this.checkValid("undeleted\r\n", key);
        this.checkValid("UnDeleted\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("und\r\n", key);
        this.checkInvalid("unde\r\n", key);
        this.checkInvalid("undel\r\n", key);
        this.checkInvalid("undele\r\n", key);
        this.checkInvalid("undelet\r\n", key);
        this.checkInvalid("undelete\r\n", key);
    }

    @Test
    public void testShouldParseUnseen() throws Exception {
        SearchKey key = SearchKey.buildUnseen();
        this.checkValid("UNSEEN\r\n", key);
        this.checkValid("unseen\r\n", key);
        this.checkValid("UnSeen\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("uns\r\n", key);
        this.checkInvalid("unse\r\n", key);
        this.checkInvalid("unsee\r\n", key);
    }

    @Test
    public void testShouldParseUndraft() throws Exception {
        SearchKey key = SearchKey.buildUndraft();
        this.checkValid("UNDRAFT\r\n", key);
        this.checkValid("undraft\r\n", key);
        this.checkValid("UnDraft\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("und\r\n", key);
        this.checkInvalid("undr\r\n", key);
        this.checkInvalid("undra\r\n", key);
        this.checkInvalid("undraf\r\n", key);
    }

    @Test
    public void testShouldParseUnflagged() throws Exception {
        SearchKey key = SearchKey.buildUnflagged();
        this.checkValid("UNFLAGGED\r\n", key);
        this.checkValid("unflagged\r\n", key);
        this.checkValid("UnFlagged\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("un\r\n", key);
        this.checkInvalid("unf\r\n", key);
        this.checkInvalid("unfl\r\n", key);
        this.checkInvalid("unfla\r\n", key);
        this.checkInvalid("unflag\r\n", key);
        this.checkInvalid("unflagg\r\n", key);
        this.checkInvalid("unflagge\r\n", key);
    }

    @Test
    public void testShouldParseSeen() throws Exception {
        SearchKey key = SearchKey.buildSeen();
        this.checkValid("SEEN\r\n", key);
        this.checkValid("seen\r\n", key);
        this.checkValid("SEen\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("se\r\n", key);
        this.checkInvalid("see\r\n", key);
    }

    @Test
    public void testShouldParseNew() throws Exception {
        SearchKey key = SearchKey.buildNew();
        this.checkValid("NEW\r\n", key);
        this.checkValid("new\r\n", key);
        this.checkValid("NeW\r\n", key);
        this.checkInvalid("n\r\n", key);
        this.checkInvalid("ne\r\n", key);
        this.checkInvalid("nwe\r\n", key);
    }

    @Test
    public void testShouldParseOld() throws Exception {
        SearchKey key = SearchKey.buildOld();
        this.checkValid("OLD\r\n", key);
        this.checkValid("old\r\n", key);
        this.checkValid("oLd\r\n", key);
        this.checkInvalid("o\r\n", key);
        this.checkInvalid("ol\r\n", key);
        this.checkInvalid("olr\r\n", key);
    }

    @Test
    public void testShouldParseFlagged() throws Exception {
        SearchKey key = SearchKey.buildFlagged();
        this.checkValid("FLAGGED\r\n", key);
        this.checkValid("flagged\r\n", key);
        this.checkValid("FLAGged\r\n", key);
        this.checkInvalid("F\r\n", key);
        this.checkInvalid("FL\r\n", key);
        this.checkInvalid("FLA\r\n", key);
        this.checkInvalid("FLAG\r\n", key);
        this.checkInvalid("FLAGG\r\n", key);
        this.checkInvalid("FLAGGE\r\n", key);
        this.checkInvalid("FLoas\r\n", key);
    }

    @Test
    public void testShouldParseSmaller() throws Exception {
        SearchKey key = SearchKey.buildSmaller((long)1729L);
        this.checkValid("SMALLER 1729\r\n", key);
        this.checkValid("smaller 1729\r\n", key);
        this.checkValid("SMaller 1729\r\n", key);
        this.checkInvalid("s\r\n", key);
        this.checkInvalid("sm\r\n", key);
        this.checkInvalid("sma\r\n", key);
        this.checkInvalid("smal\r\n", key);
        this.checkInvalid("small\r\n", key);
        this.checkInvalid("smalle\r\n", key);
        this.checkInvalid("smaller \r\n", key);
        this.checkInvalid("smaller peach\r\n", key);
    }

    @Test
    public void testShouldParseLarger() throws Exception {
        SearchKey key = SearchKey.buildLarger((long)1234L);
        this.checkValid("LARGER 1234\r\n", key);
        this.checkValid("lArGEr 1234\r\n", key);
        this.checkValid("larger 1234\r\n", key);
        this.checkInvalid("l\r\n", key);
        this.checkInvalid("la\r\n", key);
        this.checkInvalid("lar\r\n", key);
        this.checkInvalid("larg\r\n", key);
        this.checkInvalid("large\r\n", key);
        this.checkInvalid("larger\r\n", key);
        this.checkInvalid("larger \r\n", key);
        this.checkInvalid("larger peach\r\n", key);
    }

    @Test
    public void testShouldParseUid() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(1L)};
        SearchKey key = SearchKey.buildUidSet((IdRange[])range);
        this.checkValid("UID 1\r\n", key);
        this.checkValid("Uid 1\r\n", key);
        this.checkValid("uid 1\r\n", key);
        this.checkInvalid("u\r\n", key);
        this.checkInvalid("ui\r\n", key);
        this.checkInvalid("uid\r\n", key);
        this.checkInvalid("uid \r\n", key);
    }

    @Test
    public void testShouldParseNot() throws Exception {
        SearchKey notdKey = SearchKey.buildSeen();
        SearchKey key = SearchKey.buildNot((SearchKey)notdKey);
        this.checkValid("NOT SEEN\r\n", key);
        this.checkValid("Not seen\r\n", key);
        this.checkValid("not Seen\r\n", key);
        this.checkInvalid("n\r\n", key);
        this.checkInvalid("no\r\n", key);
        this.checkInvalid("not\r\n", key);
        this.checkInvalid("not \r\n", key);
    }

    @Test
    public void testShouldParseOr() throws Exception {
        SearchKey oneKey = SearchKey.buildSeen();
        SearchKey twoKey = SearchKey.buildDraft();
        SearchKey key = SearchKey.buildOr((SearchKey)oneKey, (SearchKey)twoKey);
        this.checkValid("OR SEEN DRAFT\r\n", key);
        this.checkValid("oR seen draft\r\n", key);
        this.checkValid("or Seen drAFT\r\n", key);
        this.checkInvalid("o\r\n", key);
        this.checkInvalid("or\r\n", key);
        this.checkInvalid("or \r\n", key);
        this.checkInvalid("or seen\r\n", key);
        this.checkInvalid("or seen \r\n", key);
    }

    @Test
    public void testShouldParseSequenceSet() throws Exception {
        this.checkSequenceSet(1);
        this.checkSequenceSet(2);
        this.checkSequenceSet(3);
        this.checkSequenceSet(4);
        this.checkSequenceSet(5);
        this.checkSequenceSet(6);
        this.checkSequenceSet(7);
        this.checkSequenceSet(8);
        this.checkSequenceSet(9);
        this.checkSequenceSet(10);
        this.checkSequenceSet(121);
        this.checkSequenceSet(11354);
        this.checkSequenceSet(145644656);
        this.checkSequenceSet(1456452213);
    }

    private void checkSequenceSet(int number) throws Exception {
        IdRange[] range = new IdRange[]{new IdRange((long)number)};
        SearchKey key = SearchKey.buildSequenceSet((IdRange[])range);
        this.checkValid(number + "\r\n", key);
    }

    private void checkInvalid(String input, SearchKey key) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        try {
            this.parser.searchKey((ImapRequestLineReader)reader, null, false);
            Assert.fail((String)"Expected protocol exception to be throw since input is invalid");
        }
        catch (DecodingException e) {
            // empty catch block
        }
    }
}

