/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserSearchKeySequenceSetTest {
    SearchCommandParser parser;
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;
    private Mockery mockery = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.mockery.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.mockery.mock(ImapMessage.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
    }

    @Test
    public void testAllNumbers() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(2L), new IdRange(4L), new IdRange(9L), new IdRange(16L), new IdRange(25L), new IdRange(36L), new IdRange(49L), new IdRange(64L), new IdRange(81L), new IdRange(100L)};
        this.check("2,4,9,16,25,36,49,64,81,100", range);
    }

    @Test
    public void testEndStar() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(8L), new IdRange(9L, 10L), new IdRange(17L), new IdRange(100L, Long.MAX_VALUE)};
        this.check("8,9:10,17,100:*", range);
    }

    @Test
    public void testStartStar() throws Exception {
        IdRange[] range = new IdRange[]{new IdRange(Long.MAX_VALUE, 9L), new IdRange(15L), new IdRange(799L, 820L)};
        this.check("*:9,15,799:820", range);
    }

    private void check(String sequence, IdRange[] range) throws Exception {
        this.checkUid(sequence, range);
        this.checkSequence(sequence, range);
    }

    private void checkUid(String sequence, IdRange[] range) throws Exception {
        SearchKey key = SearchKey.buildUidSet((IdRange[])range);
        this.checkValid("UID " + sequence, key);
        this.checkValid("uid " + sequence, key);
        this.checkValid("Uid " + sequence, key);
    }

    private void checkSequence(String sequence, IdRange[] range) throws Exception {
        SearchKey key = SearchKey.buildSequenceSet((IdRange[])range);
        this.checkValid(sequence, key);
        this.checkValid(sequence, key);
        this.checkValid(sequence, key);
    }

    private void checkValid(String input, SearchKey key) throws Exception {
        input = input + "\r\n";
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        SearchKey searchKey = this.parser.searchKey((ImapRequestLineReader)reader, null, false);
        Assert.assertEquals((Object)key, (Object)searchKey);
    }
}

