/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserOrTest {
    SearchCommandParser parser;
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.context.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.context.mock(ImapMessage.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
    }

    public Input sequence() {
        IdRange[] range = new IdRange[]{new IdRange(Long.MAX_VALUE, 100L), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildSequenceSet((IdRange[])range);
        return new Input("*:100,110,200:201,400:*", key);
    }

    public Input uid() {
        IdRange[] range = new IdRange[]{new IdRange(Long.MAX_VALUE, 100L), new IdRange(110L), new IdRange(200L, 201L), new IdRange(400L, Long.MAX_VALUE)};
        SearchKey key = SearchKey.buildUidSet((IdRange[])range);
        return new Input("UID *:100,110,200:201,400:*", key);
    }

    public Input header() {
        SearchKey key = SearchKey.buildHeader((String)"FROM", (String)"Smith");
        return new Input("HEADER FROM Smith", key);
    }

    public Input date() {
        SearchKey key = SearchKey.buildSince((DayMonthYear)new DayMonthYear(11, 1, 2001));
        return new Input("since 11-Jan-2001", key);
    }

    public Input stringUnquoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith");
        return new Input("FROM Smith", key);
    }

    public Input stringQuoted() {
        SearchKey key = SearchKey.buildFrom((String)"Smith And Jones");
        return new Input("FROM \"Smith And Jones\"", key);
    }

    public Input draft() {
        SearchKey key = SearchKey.buildDraft();
        return new Input("DRAFT", key);
    }

    @Test
    public void testDraftPermutations() throws Exception {
        this.checkValid(this.draft(), this.draft());
        this.checkValid(this.draft(), this.stringQuoted());
        this.checkValid(this.draft(), this.stringUnquoted());
        this.checkValid(this.draft(), this.sequence());
        this.checkValid(this.draft(), this.header());
        this.checkValid(this.draft(), this.date());
        this.checkValid(this.draft(), this.uid());
    }

    @Test
    public void testDatePermutations() throws Exception {
        this.checkValid(this.date(), this.draft());
        this.checkValid(this.date(), this.stringQuoted());
        this.checkValid(this.date(), this.stringUnquoted());
        this.checkValid(this.date(), this.sequence());
        this.checkValid(this.date(), this.header());
        this.checkValid(this.date(), this.date());
        this.checkValid(this.date(), this.uid());
    }

    @Test
    public void testHeaderPermutations() throws Exception {
        this.checkValid(this.header(), this.draft());
        this.checkValid(this.header(), this.stringQuoted());
        this.checkValid(this.header(), this.stringUnquoted());
        this.checkValid(this.header(), this.sequence());
        this.checkValid(this.header(), this.header());
        this.checkValid(this.header(), this.date());
        this.checkValid(this.header(), this.uid());
    }

    @Test
    public void testSequencePermutations() throws Exception {
        this.checkValid(this.sequence(), this.draft());
        this.checkValid(this.sequence(), this.stringQuoted());
        this.checkValid(this.sequence(), this.stringUnquoted());
        this.checkValid(this.sequence(), this.sequence());
        this.checkValid(this.sequence(), this.header());
        this.checkValid(this.sequence(), this.date());
        this.checkValid(this.sequence(), this.uid());
    }

    @Test
    public void testStringQuotedPermutations() throws Exception {
        this.checkValid(this.stringQuoted(), this.draft());
        this.checkValid(this.stringQuoted(), this.stringQuoted());
        this.checkValid(this.stringQuoted(), this.stringUnquoted());
        this.checkValid(this.stringQuoted(), this.sequence());
        this.checkValid(this.stringQuoted(), this.header());
        this.checkValid(this.stringQuoted(), this.date());
        this.checkValid(this.stringQuoted(), this.uid());
    }

    @Test
    public void testStringUnquotedPermutations() throws Exception {
        this.checkValid(this.stringUnquoted(), this.draft());
        this.checkValid(this.stringUnquoted(), this.stringQuoted());
        this.checkValid(this.stringUnquoted(), this.stringUnquoted());
        this.checkValid(this.stringUnquoted(), this.sequence());
        this.checkValid(this.stringUnquoted(), this.header());
        this.checkValid(this.stringUnquoted(), this.date());
        this.checkValid(this.stringUnquoted(), this.uid());
    }

    @Test
    public void testUidPermutations() throws Exception {
        this.checkValid(this.uid(), this.draft());
        this.checkValid(this.uid(), this.stringQuoted());
        this.checkValid(this.uid(), this.stringUnquoted());
        this.checkValid(this.uid(), this.sequence());
        this.checkValid(this.uid(), this.header());
        this.checkValid(this.uid(), this.date());
        this.checkValid(this.uid(), this.uid());
    }

    private void checkValid(Input one, Input two) throws Exception {
        String input = "OR " + one.input + " " + two.input + "\r\n";
        SearchKey key = SearchKey.buildOr((SearchKey)one.key, (SearchKey)two.key);
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        Assert.assertEquals((Object)key, (Object)this.parser.searchKey((ImapRequestLineReader)reader, null, false));
    }

    public class Input {
        public String input;
        public SearchKey key;

        public Input(String input, SearchKey key) {
            this.input = input;
            this.key = key;
        }
    }
}

