/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.MockLogger;
import org.apache.james.imap.decode.parser.NioUtils;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class SearchCommandParserCharsetTest {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final String TAG = "A1";
    private static final String ASCII_SEARCH_TERM = "A Search Term";
    private static final String NON_ASCII_SEARCH_TERM = "\u043a\u0430\u043a \u0414\u0435\u043b\u0430?";
    private static final byte[] BYTES_NON_ASCII_SEARCH_TERM = NioUtils.toBytes("\u043a\u0430\u043a \u0414\u0435\u043b\u0430?", UTF8);
    private static final byte[] BYTES_UTF8_NON_ASCII_SEARCH_TERM = NioUtils.add(NioUtils.toBytes(" {16}\r\n", ASCII), BYTES_NON_ASCII_SEARCH_TERM);
    private static final byte[] CHARSET = NioUtils.toBytes("CHARSET UTF-8 ", ASCII);
    SearchCommandParser parser;
    StatusResponseFactory mockStatusResponseFactory;
    private Mockery context = new JUnit4Mockery();
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;

    @Before
    public void setUp() throws Exception {
        this.parser = new SearchCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.context.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.context.mock(ImapMessage.class);
        this.mockStatusResponseFactory = (StatusResponseFactory)this.context.mock(StatusResponseFactory.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
        this.parser.setStatusResponseFactory(this.mockStatusResponseFactory);
    }

    @Test
    public void testBadCharset() throws Exception {
        final HashSet<String> charsetNames = new HashSet<String>();
        for (Charset charset : Charset.availableCharsets().values()) {
            Set<String> aliases = charset.aliases();
            charsetNames.addAll(aliases);
        }
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StatusResponseFactory)this.oneOf(SearchCommandParserCharsetTest.this.mockStatusResponseFactory)).taggedNo((String)this.with(1.equal((Object)SearchCommandParserCharsetTest.TAG)), (ImapCommand)this.with(1.same((Object)SearchCommandParserCharsetTest.this.command)), (HumanReadableText)this.with(1.equal((Object)HumanReadableText.BAD_CHARSET)), (StatusResponse.ResponseCode)this.with(1.equal((Object)StatusResponse.ResponseCode.badCharset((Collection)charsetNames))));
            }
        });
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream("CHARSET BOGUS ".getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        this.parser.decode(this.command, (ImapRequestLineReader)reader, TAG, false, (Log)new MockLogger());
    }

    @Test
    public void testBCCShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildBcc((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("BCC".getBytes("US-ASCII"), key);
    }

    @Test
    public void testBODYShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildBody((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("BODY".getBytes("US-ASCII"), key);
    }

    @Test
    public void testCCShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildCc((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("CC".getBytes("US-ASCII"), key);
    }

    @Test
    public void testFROMShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildFrom((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("FROM".getBytes("US-ASCII"), key);
    }

    @Test
    public void testHEADERShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildHeader((String)"whatever", (String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("HEADER whatever".getBytes("US-ASCII"), key);
    }

    @Test
    public void testSUBJECTShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildSubject((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("SUBJECT".getBytes("US-ASCII"), key);
    }

    @Test
    public void testTEXTShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildText((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("TEXT".getBytes("US-ASCII"), key);
    }

    @Test
    public void testTOShouldConvertCharset() throws Exception {
        SearchKey key = SearchKey.buildTo((String)NON_ASCII_SEARCH_TERM);
        this.checkUTF8Valid("TO".getBytes("US-ASCII"), key);
    }

    @Test
    public void testASCIICharset() throws Exception {
        SearchKey key = SearchKey.buildBcc((String)ASCII_SEARCH_TERM);
        this.checkValid("CHARSET US-ASCII BCC \"A Search Term\"", key, true, "US-ASCII");
    }

    @Test
    public void testSimpleUTF8Charset() throws Exception {
        SearchKey key = SearchKey.buildBcc((String)ASCII_SEARCH_TERM);
        this.checkValid("CHARSET UTF-8 BCC \"A Search Term\"", key, true, "US-ASCII");
    }

    private void checkUTF8Valid(byte[] term, SearchKey key) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(NioUtils.add(NioUtils.add(CHARSET, term), BYTES_UTF8_NON_ASCII_SEARCH_TERM)), (OutputStream)new ByteArrayOutputStream());
        SearchKey searchKey = this.parser.searchKey((ImapRequestLineReader)reader, null, true);
        Assert.assertEquals((Object)key, (Object)searchKey);
    }

    private void checkValid(String input, SearchKey key, boolean isFirst, String charset) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes(charset)), (OutputStream)new ByteArrayOutputStream());
        SearchKey searchKey = this.parser.searchKey((ImapRequestLineReader)reader, null, isFirst);
        Assert.assertEquals((Object)key, (Object)searchKey);
    }
}

