/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapMessageFactory;
import org.apache.james.imap.api.message.BodyFetchElement;
import org.apache.james.imap.api.message.FetchData;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.ImapRequestStreamLineReader;
import org.apache.james.imap.decode.parser.FetchCommandParser;
import org.apache.james.imap.decode.parser.MockLogger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class FetchCommandParserPartialFetchTest {
    Mockery context = new JUnit4Mockery();
    FetchCommandParser parser;
    ImapMessageFactory mockMessageFactory;
    ImapCommand command;
    ImapMessage message;

    @Before
    public void setUp() throws Exception {
        this.parser = new FetchCommandParser();
        this.mockMessageFactory = (ImapMessageFactory)this.context.mock(ImapMessageFactory.class);
        this.command = ImapCommand.anyStateCommand((String)"Command");
        this.message = (ImapMessage)this.context.mock(ImapMessage.class);
        this.parser.setMessageFactory(this.mockMessageFactory);
    }

    @Test
    public void testShouldParseZeroAndLength() throws Exception {
        IdRange[] ranges = new IdRange[]{new IdRange(1L)};
        FetchData data = new FetchData();
        data.add(new BodyFetchElement("BODY[]", 5, null, null, new Long(0L), new Long(100L)), false);
        this.check("1 (BODY[]<0.100>)\r\n", ranges, false, data, "A01");
    }

    @Test
    public void testShouldParseNonZeroAndLength() throws Exception {
        IdRange[] ranges = new IdRange[]{new IdRange(1L)};
        FetchData data = new FetchData();
        data.add(new BodyFetchElement("BODY[]", 5, null, null, new Long(20L), new Long(12342348L)), false);
        this.check("1 (BODY[]<20.12342348>)\r\n", ranges, false, data, "A01");
    }

    @Test
    public void testShouldNotParseZeroLength() throws Exception {
        try {
            ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream("1 (BODY[]<20.0>)\r\n".getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
            this.parser.decode(this.command, (ImapRequestLineReader)reader, "A01", false, (Log)new MockLogger());
            throw new Exception("Number of octets must be non-zero");
        }
        catch (DecodingException decodingException) {
            return;
        }
    }

    private void check(String input, final IdRange[] idSet, final boolean useUids, final FetchData data, final String tag) throws Exception {
        ImapRequestStreamLineReader reader = new ImapRequestStreamLineReader((InputStream)new ByteArrayInputStream(input.getBytes("US-ASCII")), (OutputStream)new ByteArrayOutputStream());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ImapMessageFactory)this.oneOf(FetchCommandParserPartialFetchTest.this.mockMessageFactory)).createFetchMessage((ImapCommand)this.with(1.equal((Object)FetchCommandParserPartialFetchTest.this.command)), this.with(1.equal((Object)useUids)), (IdRange[])this.with(1.equal((Object)idSet)), (FetchData)this.with(1.equal((Object)data)), (String)this.with(1.same((Object)tag)));
                this.will(1.returnValue((Object)FetchCommandParserPartialFetchTest.this.message));
            }
        });
        this.parser.decode(this.command, (ImapRequestLineReader)reader, tag, useUids, (Log)new MockLogger());
    }
}

