/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message.response;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestForStatusResponseFactory {
    private static final String TAG = "ATAG";
    private static final HumanReadableText KEY = new HumanReadableText("KEY", "TEXT");
    private static final StatusResponse.ResponseCode CODE = StatusResponse.ResponseCode.alert();
    private ImapCommand command;
    StatusResponseFactory factory;

    protected abstract StatusResponseFactory createInstance();

    @Before
    public void setUp() throws Exception {
        this.factory = this.createInstance();
        this.command = ImapCommand.anyStateCommand((String)"Command");
    }

    @Test
    public void testTaggedOk() {
        StatusResponse response = this.factory.taggedOk(TAG, this.command, KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.OK, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
        Assert.assertNull((Object)response.getResponseCode());
        response = this.factory.taggedOk(TAG, this.command, KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.OK, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
    }

    @Test
    public void testTaggedNo() {
        StatusResponse response = this.factory.taggedNo(TAG, this.command, KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.NO, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
        Assert.assertNull((Object)response.getResponseCode());
        response = this.factory.taggedNo(TAG, this.command, KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.NO, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
    }

    @Test
    public void testTaggedBad() {
        StatusResponse response = this.factory.taggedBad(TAG, this.command, KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BAD, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
        response = this.factory.taggedBad(TAG, this.command, KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BAD, (Object)response.getServerResponseType());
        Assert.assertEquals((Object)TAG, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertEquals((Object)this.command, (Object)response.getCommand());
    }

    @Test
    public void testUntaggedOk() {
        StatusResponse response = this.factory.untaggedOk(KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.OK, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
        response = this.factory.untaggedOk(KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.OK, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
    }

    @Test
    public void testUntaggedNo() {
        StatusResponse response = this.factory.untaggedNo(KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.NO, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
        response = this.factory.untaggedNo(KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.NO, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
    }

    @Test
    public void testUntaggedBad() {
        StatusResponse response = this.factory.untaggedBad(KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BAD, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
        response = this.factory.untaggedBad(KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BAD, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
    }

    @Test
    public void testPreauth() {
        StatusResponse response = this.factory.preauth(KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.PREAUTH, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
        response = this.factory.preauth(KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.PREAUTH, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
    }

    @Test
    public void testBye() {
        StatusResponse response = this.factory.bye(KEY);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BYE, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertNull((Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
        response = this.factory.bye(KEY, CODE);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)StatusResponse.Type.BYE, (Object)response.getServerResponseType());
        Assert.assertEquals(null, (Object)response.getTag());
        Assert.assertEquals((Object)KEY, (Object)response.getTextKey());
        Assert.assertEquals((Object)CODE, (Object)response.getResponseCode());
        Assert.assertNull((Object)response.getCommand());
    }
}

