/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.message.IdRange;
import org.junit.Assert;
import org.junit.Test;

public class IdRangeTest {
    @Test
    public void testNotMerge() {
        IdRange r = new IdRange(0L, 2L);
        IdRange r2 = new IdRange(4L, 5L);
        IdRange r3 = new IdRange(7L, 10L);
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        ranges.add(r);
        ranges.add(r2);
        ranges.add(r3);
        List merged = IdRange.mergeRanges(ranges);
        Assert.assertEquals((long)3L, (long)merged.size());
        Iterator rIt = merged.iterator();
        this.checkIdRange(r, (IdRange)rIt.next());
        this.checkIdRange(r2, (IdRange)rIt.next());
        this.checkIdRange(r3, (IdRange)rIt.next());
        Assert.assertFalse((boolean)rIt.hasNext());
    }

    @Test
    public void testMerge() {
        IdRange r = new IdRange(0L, 2L);
        IdRange r2 = new IdRange(1L, 4L);
        IdRange r3 = new IdRange(6L, 7L);
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        ranges.add(r);
        ranges.add(r2);
        ranges.add(r3);
        List merged = IdRange.mergeRanges(ranges);
        Assert.assertEquals((long)2L, (long)merged.size());
        Iterator rIt = merged.iterator();
        this.checkIdRange(new IdRange(0L, 4L), (IdRange)rIt.next());
        this.checkIdRange(r3, (IdRange)rIt.next());
        Assert.assertFalse((boolean)rIt.hasNext());
    }

    @Test
    public void testMerge2() {
        IdRange r = new IdRange(0L, 10L);
        IdRange r2 = new IdRange(1L, 4L);
        IdRange r3 = new IdRange(5L, 7L);
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        ranges.add(r);
        ranges.add(r2);
        ranges.add(r3);
        List merged = IdRange.mergeRanges(ranges);
        Assert.assertEquals((long)1L, (long)merged.size());
        Iterator rIt = merged.iterator();
        this.checkIdRange(new IdRange(0L, 10L), (IdRange)rIt.next());
        Assert.assertFalse((boolean)rIt.hasNext());
    }

    @Test
    public void testMerge3() {
        IdRange r = new IdRange(0L, 10L);
        IdRange r2 = new IdRange(1L, 4L);
        IdRange r3 = new IdRange(10L, 15L);
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        ranges.add(r);
        ranges.add(r2);
        ranges.add(r3);
        List merged = IdRange.mergeRanges(ranges);
        Assert.assertEquals((long)1L, (long)merged.size());
        Iterator rIt = merged.iterator();
        this.checkIdRange(new IdRange(0L, 15L), (IdRange)rIt.next());
        Assert.assertFalse((boolean)rIt.hasNext());
    }

    @Test
    public void testMerge4() {
        IdRange r = new IdRange(0L, 1L);
        IdRange r2 = new IdRange(1L, 1L);
        IdRange r3 = new IdRange(2L, 2L);
        ArrayList<IdRange> ranges = new ArrayList<IdRange>();
        ranges.add(r);
        ranges.add(r2);
        ranges.add(r3);
        List merged = IdRange.mergeRanges(ranges);
        Assert.assertEquals((long)1L, (long)merged.size());
        Iterator rIt = merged.iterator();
        this.checkIdRange(new IdRange(0L, 2L), (IdRange)rIt.next());
        Assert.assertFalse((boolean)rIt.hasNext());
    }

    private void checkIdRange(IdRange r1, IdRange r2) {
        Assert.assertEquals((long)r1.getLowVal(), (long)r2.getLowVal());
        Assert.assertEquals((long)r1.getHighVal(), (long)r2.getHighVal());
    }
}

