/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import org.apache.james.imap.api.ImapSessionState;

public class ImapCommand {
    private final boolean validInAuthenticated;
    private final boolean validInSelected;
    private final boolean validInNonAuthenticated;
    private final String name;

    public static ImapCommand nonAuthenticatedStateCommand(String name) {
        return new ImapCommand(false, false, true, name);
    }

    public static ImapCommand authenticatedStateCommand(String name) {
        return new ImapCommand(true, true, false, name);
    }

    public static ImapCommand selectedStateCommand(String name) {
        return new ImapCommand(false, true, false, name);
    }

    public static ImapCommand anyStateCommand(String name) {
        return new ImapCommand(true, true, true, name);
    }

    private ImapCommand(boolean validInAuthenticated, boolean validInSelected, boolean validInNonAuthenticated, String name) {
        this.validInAuthenticated = validInAuthenticated;
        this.validInSelected = validInSelected;
        this.validInNonAuthenticated = validInNonAuthenticated;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean validForState(ImapSessionState state) {
        boolean result;
        switch (state) {
            case AUTHENTICATED: {
                result = this.validInAuthenticated;
                break;
            }
            case NON_AUTHENTICATED: {
                result = this.validInNonAuthenticated;
                break;
            }
            case SELECTED: {
                result = this.validInSelected;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        return this.name;
    }
}

