/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backend.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownNotifier;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.PreDestroy;
import org.apache.james.backend.rabbitmq.RabbitMQChannelPool;
import org.apache.james.backend.rabbitmq.RabbitMQConnectionFactory;

public class SimpleChannelPool
implements RabbitMQChannelPool {
    private final AtomicReference<Channel> channelReference;
    private final AtomicReference<Connection> connectionReference;
    private final RabbitMQConnectionFactory connectionFactory;

    public SimpleChannelPool(RabbitMQConnectionFactory factory) {
        this.connectionFactory = factory;
        this.connectionReference = new AtomicReference();
        this.channelReference = new AtomicReference();
    }

    @Override
    public synchronized <T, E extends Throwable> T execute(RabbitMQChannelPool.RabbitFunction<T, E> f) throws E, RabbitMQChannelPool.ConnectionFailedException {
        return f.execute(this.getResilientChannel());
    }

    @Override
    public synchronized <E extends Throwable> void execute(RabbitMQChannelPool.RabbitConsumer<E> f) throws E, RabbitMQChannelPool.ConnectionFailedException {
        f.execute(this.getResilientChannel());
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        Optional.ofNullable(this.channelReference.get()).filter(ShutdownNotifier::isOpen).ifPresent(Throwing.consumer(Channel::close).sneakyThrow());
        Optional.ofNullable(this.connectionReference.get()).filter(ShutdownNotifier::isOpen).ifPresent(Throwing.consumer(Connection::close).sneakyThrow());
    }

    private Connection getResilientConnection() {
        return this.connectionReference.updateAndGet(this::getOpenConnection);
    }

    private Connection getOpenConnection(Connection checkedConnection) {
        return Optional.ofNullable(checkedConnection).filter(ShutdownNotifier::isOpen).orElseGet(this.connectionFactory::create);
    }

    private Channel getResilientChannel() {
        return this.channelReference.updateAndGet((UnaryOperator<Channel>)Throwing.unaryOperator(this::getOpenChannel));
    }

    private Channel getOpenChannel(Channel checkedChannel) {
        return Optional.ofNullable(checkedChannel).filter(ShutdownNotifier::isOpen).orElseGet(Throwing.supplier(() -> this.getResilientConnection().createChannel()).sneakyThrow());
    }
}

