/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backend.rabbitmq;

import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import org.apache.james.backend.rabbitmq.RabbitMQChannelPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQHealthCheck.class);
    private static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQ backend");
    private final RabbitMQChannelPool rabbitChannelPoolImpl;

    @Inject
    public RabbitMQHealthCheck(RabbitMQChannelPool rabbitChannelPoolImpl) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        this.rabbitChannelPoolImpl = rabbitChannelPoolImpl;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Result check() {
        try {
            return this.rabbitChannelPoolImpl.execute(channel -> {
                if (channel.isOpen()) {
                    return Result.healthy((ComponentName)COMPONENT_NAME);
                }
                LOGGER.error("The created connection was not opened");
                return Result.unhealthy((ComponentName)COMPONENT_NAME);
            });
        }
        catch (Exception e) {
            LOGGER.error("Unhealthy RabbitMQ instances: could not establish a connection", (Throwable)e);
            return Result.unhealthy((ComponentName)COMPONENT_NAME);
        }
    }
}

