/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backend.rabbitmq;

import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.apache.james.backend.rabbitmq.RabbitMQConfiguration;
import org.apache.james.util.retry.RetryExecutorUtil;

public class RabbitMQConnectionFactory {
    private final AsyncRetryExecutor executor;
    private final ConnectionFactory connectionFactory;
    private final int maxRetries;
    private final int minDelay;

    @Inject
    public RabbitMQConnectionFactory(RabbitMQConfiguration rabbitMQConfiguration, AsyncRetryExecutor executor) {
        this.executor = executor;
        this.connectionFactory = this.from(rabbitMQConfiguration);
        this.maxRetries = rabbitMQConfiguration.getMaxRetries();
        this.minDelay = rabbitMQConfiguration.getMinDelay();
    }

    private ConnectionFactory from(RabbitMQConfiguration rabbitMQConfiguration) {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(rabbitMQConfiguration.getUri());
            return connectionFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection create() {
        try {
            return (Connection)RetryExecutorUtil.retryOnExceptions((AsyncRetryExecutor)this.executor, (int)this.maxRetries, (int)this.minDelay, (Class[])new Class[]{Exception.class}).getWithRetry(context -> this.connectionFactory.newConnection()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

