/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backend.rabbitmq;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;

public class RabbitMQConfiguration {
    private static final String URI_PROPERTY_NAME = "uri";
    private static final String MANAGEMENT_URI_PROPERTY_NAME = "management.uri";
    private final URI uri;
    private final URI managementUri;
    private final int maxRetries;
    private final int minDelay;
    private final ManagementCredentials managementCredentials;

    public static RequireAmqpUri builder() {
        return amqpUri -> managementUri -> managementCredentials -> new Builder(amqpUri, managementUri, managementCredentials);
    }

    public static RabbitMQConfiguration from(Configuration configuration) {
        String uriAsString = configuration.getString(URI_PROPERTY_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)uriAsString) ? 1 : 0) != 0, (Object)"You need to specify the URI of RabbitMQ");
        URI amqpUri = RabbitMQConfiguration.checkURI(uriAsString);
        String managementUriAsString = configuration.getString(MANAGEMENT_URI_PROPERTY_NAME);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)managementUriAsString) ? 1 : 0) != 0, (Object)"You need to specify the management URI of RabbitMQ");
        URI managementUri = RabbitMQConfiguration.checkURI(managementUriAsString);
        ManagementCredentials managementCredentials = ManagementCredentials.from(configuration);
        return RabbitMQConfiguration.builder().amqpUri(amqpUri).managementUri(managementUri).managementCredentials(managementCredentials).build();
    }

    private static URI checkURI(String uri) {
        try {
            return URI.create(uri);
        }
        catch (Exception e) {
            throw new IllegalStateException("You need to specify a valid URI", e);
        }
    }

    private RabbitMQConfiguration(URI uri, URI managementUri, ManagementCredentials managementCredentials, int maxRetries, int minDelay) {
        this.uri = uri;
        this.managementUri = managementUri;
        this.managementCredentials = managementCredentials;
        this.maxRetries = maxRetries;
        this.minDelay = minDelay;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getManagementUri() {
        return this.managementUri;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public ManagementCredentials getManagementCredentials() {
        return this.managementCredentials;
    }

    public final boolean equals(Object o) {
        if (o instanceof RabbitMQConfiguration) {
            RabbitMQConfiguration that = (RabbitMQConfiguration)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.managementUri, that.managementUri) && Objects.equals(this.maxRetries, that.maxRetries) && Objects.equals(this.minDelay, that.minDelay) && Objects.equals(this.managementCredentials, that.managementCredentials);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uri, this.managementUri, this.maxRetries, this.minDelay, this.managementCredentials);
    }

    public static class Builder {
        static final int DEFAULT_MAX_RETRIES = 7;
        static final int DEFAULT_MIN_DELAY = 3000;
        private final URI amqpUri;
        private final URI managementUri;
        private final ManagementCredentials managementCredentials;
        private Optional<Integer> maxRetries;
        private Optional<Integer> minDelay;

        private Builder(URI amqpUri, URI managementUri, ManagementCredentials managementCredentials) {
            this.amqpUri = amqpUri;
            this.managementUri = managementUri;
            this.managementCredentials = managementCredentials;
            this.maxRetries = Optional.empty();
            this.minDelay = Optional.empty();
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = Optional.of(maxRetries);
            return this;
        }

        public Builder minDelay(int minDelay) {
            this.minDelay = Optional.of(minDelay);
            return this;
        }

        public RabbitMQConfiguration build() {
            Preconditions.checkNotNull((Object)this.amqpUri, (Object)"'amqpUri' should not be null");
            Preconditions.checkNotNull((Object)this.managementUri, (Object)"'managementUri' should not be null");
            Preconditions.checkNotNull((Object)this.managementCredentials, (Object)"'managementCredentials' should not be null");
            return new RabbitMQConfiguration(this.amqpUri, this.managementUri, this.managementCredentials, this.maxRetries.orElse(7), this.minDelay.orElse(3000));
        }
    }

    @FunctionalInterface
    public static interface RequireManagementCredentials {
        public Builder managementCredentials(ManagementCredentials var1);
    }

    @FunctionalInterface
    public static interface RequireManagementUri {
        public RequireManagementCredentials managementUri(URI var1);
    }

    @FunctionalInterface
    public static interface RequireAmqpUri {
        public RequireManagementUri amqpUri(URI var1);
    }

    public static class ManagementCredentials {
        private static final String MANAGEMENT_CREDENTIAL_USER_PROPERTY = "management.user";
        private static final String MANAGEMENT_CREDENTIAL_PASSWORD_PROPERTY = "management.password";
        private final String user;
        private final char[] password;

        static ManagementCredentials from(Configuration configuration) {
            String user = configuration.getString(MANAGEMENT_CREDENTIAL_USER_PROPERTY);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0, (Object)"You need to specify the management.user property as username of rabbitmq management admin account");
            String passwordString = configuration.getString(MANAGEMENT_CREDENTIAL_PASSWORD_PROPERTY);
            Preconditions.checkState((!Strings.isNullOrEmpty((String)passwordString) ? 1 : 0) != 0, (Object)"You need to specify the management.password property as password of rabbitmq management admin account");
            return new ManagementCredentials(user, passwordString.toCharArray());
        }

        ManagementCredentials(String user, char[] password) {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)password);
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public char[] getPassword() {
            return this.password;
        }

        public final boolean equals(Object o) {
            if (o instanceof ManagementCredentials) {
                ManagementCredentials that = (ManagementCredentials)o;
                return Objects.equals(this.user, that.user) && Arrays.equals(this.password, that.password);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.user, Arrays.hashCode(this.password));
        }
    }
}

