/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backend.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.james.backend.rabbitmq.RabbitMQChannelPool;
import org.apache.james.backend.rabbitmq.RabbitMQConnectionFactory;
import org.apache.james.util.MemoizedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitChannelPoolImpl
implements RabbitMQChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitChannelPoolImpl.class);
    private final ObjectPool<Channel> pool;
    private final ChannelBasePooledObjectFactory pooledChannelsFactory;

    @Inject
    public RabbitChannelPoolImpl(RabbitMQConnectionFactory factory) {
        this.pooledChannelsFactory = new ChannelBasePooledObjectFactory(factory);
        this.pool = new GenericObjectPool((PooledObjectFactory)this.pooledChannelsFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T execute(RabbitMQChannelPool.RabbitFunction<T, E> f) throws E, RabbitMQChannelPool.ConnectionFailedException {
        Channel channel = this.borrowChannel();
        try {
            T t = f.execute(channel);
            return t;
        }
        finally {
            this.returnChannel(channel);
        }
    }

    @Override
    public <E extends Throwable> void execute(RabbitMQChannelPool.RabbitConsumer<E> f) throws E, RabbitMQChannelPool.ConnectionFailedException {
        Channel channel = this.borrowChannel();
        try {
            f.execute(channel);
        }
        finally {
            this.returnChannel(channel);
        }
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            this.pool.close();
            this.pooledChannelsFactory.closeRabbitConnectionIfInitialized();
        }
        catch (Exception e) {
            LOGGER.error("error while closing rabbit channels & connections", (Throwable)e);
        }
    }

    private Channel borrowChannel() {
        try {
            return (Channel)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new RabbitMQChannelPool.ConnectionFailedException(e);
        }
    }

    private void returnChannel(Channel channel) {
        try {
            this.pool.returnObject((Object)channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ChannelBasePooledObjectFactory
    extends BasePooledObjectFactory<Channel> {
        private final MemoizedSupplier<Connection> rabbitConnectionSupplier = MemoizedSupplier.of((Supplier)Throwing.supplier(factory::create).sneakyThrow());

        public ChannelBasePooledObjectFactory(RabbitMQConnectionFactory factory) {
        }

        public Channel create() throws Exception {
            return ((Connection)this.rabbitConnectionSupplier.get()).createChannel();
        }

        public PooledObject<Channel> wrap(Channel obj) {
            return new DefaultPooledObject((Object)obj);
        }

        public void destroyObject(PooledObject<Channel> pooledObject) throws Exception {
            Channel channel = (Channel)pooledObject.getObject();
            if (channel.isOpen()) {
                channel.close();
            }
        }

        private void closeRabbitConnectionIfInitialized() {
            this.rabbitConnectionSupplier.ifInitialized(Throwing.consumer(this::closeRabbitConnection).sneakyThrow());
        }

        private void closeRabbitConnection(Connection connection) throws IOException {
            if (connection.isOpen()) {
                connection.close();
            }
        }
    }
}

