/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.jpa;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class JpaTestCluster {
    private final EntityManagerFactory entityManagerFactory;

    public static JpaTestCluster create(Class<?> ... clazz) {
        return JpaTestCluster.create(ImmutableList.copyOf((Object[])clazz));
    }

    public static JpaTestCluster create(List<Class<?>> clazz) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("openjpa.ConnectionDriverName", EmbeddedDriver.class.getName());
        properties.put("openjpa.ConnectionURL", "jdbc:derby:memory:mailboxintegrationtesting;create=true");
        properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        properties.put("openjpa.jdbc.SchemaFactory", "native(ForeignKeys=true)");
        properties.put("openjpa.jdbc.MappingDefaults", "ForeignKeyDeleteAction=cascade, JoinForeignKeyDeleteAction=cascade");
        properties.put("openjpa.jdbc.QuerySQLCache", "false");
        properties.put("openjpa.Log", "JDBC=WARN, SQL=WARN, Runtime=WARN");
        properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72");
        properties.put("openjpa.MetaDataFactory", "jpa(Types=" + clazz.stream().map(Class::getName).collect(Collectors.joining(";")) + ")");
        return new JpaTestCluster((EntityManagerFactory)OpenJPAPersistence.getEntityManagerFactory(properties));
    }

    private JpaTestCluster(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void clear(String ... tables) {
        this.clear((List<String>)ImmutableList.copyOf((Object[])tables));
    }

    public void clear(List<String> tables) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        entityManager.getTransaction().begin();
        for (String tableName : tables) {
            entityManager.createNativeQuery("DELETE FROM " + tableName).executeUpdate();
        }
        entityManager.getTransaction().commit();
        EntityManagerUtils.safelyClose((EntityManager)entityManager);
    }
}

